/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveByBondHandler;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveByFlHandler;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveByInitHandler;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveFromIscHandler;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveHandler;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveParam;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.business.opservice.common.chain.BusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessBatchHandlerChain;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.InterestTypeEnum;

public class LoanBillSaveService
extends AbstractTmcBizOppService {
    private BusinessBatchHandlerChain handlerChain = new BusinessBatchHandlerChain();

    public LoanBillSaveService() {
        this.handlerChain.addHandler(new BusinessBatchHandler[]{new LoanBillSaveHandler()}).addHandler(new BusinessBatchHandler[]{new LoanBillSaveByBondHandler()}).addHandler(new BusinessBatchHandler[]{new LoanBillSaveByInitHandler()}).addHandler(new BusinessBatchHandler[]{new LoanBillSaveFromIscHandler()}).addHandler(new BusinessBatchHandler[]{new LoanBillSaveByFlHandler()});
    }

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("notrepayamount");
        sic.add("amount");
        sic.add("billstatus");
        sic.add("drawamount");
        sic.add("bizdate");
        sic.add("startintdate");
        sic.add("receivedate");
        sic.add("expiredate");
        sic.add("loanrate");
        sic.add("accountbank");
        sic.add("repayamount");
        sic.add("payinterestamount");
        sic.add("endpreinstdate");
        sic.add("initendpreinstdate");
        sic.add("renewalexpiredate");
        sic.add("overduedate");
        sic.add("interesttype");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("creditlimit");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("datasource");
        sic.add("sourcebillid");
        sic.add("org");
        sic.add("creditorg");
        sic.add("registorg");
        sic.add("textdebtor");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("loancontractbill");
        sic.add("settlestatus");
        sic.add("drawway");
        sic.add("loantype");
        sic.add("underwriter_entry");
        sic.add("underwriter_entry.e_underwritertype");
        sic.add("underwriter_entry.e_isbookrunner");
        sic.add("underwriter_entry.e_underwriteratio");
        sic.add("underwriter_entry.e_underwriteamount");
        sic.add("underwriter_entry.e_underwriter");
        sic.add("issetpluspoint");
        sic.add("condition_entry_er");
        sic.add("isnofixedterm");
        sic.add("issofrrate");
        sic.add("iscallcompint");
        sic.add("intcalmethod");
        sic.add("workcalendar");
        sic.add("rateresetadjustrule");
        sic.add("stageplan");
        sic.add("repaymentway");
        sic.add("workcalendar");
        sic.add("currency");
        sic.add("fixedRepayAmount");
        sic.add("startintdate");
        sic.add("term");
        sic.add("repayplan_entry");
        sic.add("repayplan_entry.exrepaymentdate");
        sic.add("repayplan_entry.exrepaymentdate");
        sic.add("repayplan_entry.exdrawamount");
        sic.add("repayplan_entry.erepayamount");
        sic.add("repayplan_entry.enotrepayamount");
        sic.add("repayplan_entry.repayaccount");
        sic.add("repayplan_entry.repaymentmodifier");
        sic.add("repayplan_entry.repaymentmodifytime");
        sic.add("repayplan_entry.repaystate");
        sic.add("repayplan_entry.seq");
        return sic;
    }

    private void setHandleParam() {
        if (this.handlerChain.getHandleParam() == null) {
            this.handlerChain.setHandleParam(new BusinessHandleParam((Object)new LoanBillSaveParam(this.getOperationVariable(), this.getOperationResult()), null));
        }
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        this.setHandleParam();
        CfmBillCommonHelper.dealNoTermInfo(dataEntities);
        DynamicObject[] loanBills = (DynamicObject[])dataEntities.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        this.handlerChain.doBeforeProcess(loanBills);
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        LoanBillSaveService.clearFieldValueOnSave(dataEntities);
        this.setHandleParam();
        this.handlerChain.doProcess(dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        this.setHandleParam();
        this.handlerChain.doBeforeCommit(dataEntities);
    }

    private static void clearFieldValueOnSave(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String intType = dataEntity.getString("interesttype");
            if (InterestTypeEnum.FLOAT.getValue().equals(intType)) {
                String adjuststyle = dataEntity.getString("rateadjuststyle");
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(adjuststyle)) continue;
                dataEntity.set("rateadjustcycle", (Object)0);
                dataEntity.set("rateadjustcycletype", null);
                dataEntity.set("rateadjustdate", null);
                continue;
            }
            dataEntity.set("rateadjuststyle", null);
            dataEntity.set("referencerate", null);
            dataEntity.set("rateadjustcycle", (Object)0);
            dataEntity.set("rateadjustcycletype", null);
            dataEntity.set("rateadjustdate", null);
            dataEntity.set("ratesign", null);
            dataEntity.set("ratefloatpoint", null);
        }
    }
}

