/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class LoanBillScheduleSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("enotrepayamount");
        sic.add("repayplan_entry");
        sic.add("repayplan_entry.exrepaymentdate");
        sic.add("repayplan_entry.seq");
        sic.add("repayplan_entry.e_underwriteamount");
        sic.add("repayplan_entry.e_underwriter");
        sic.add("repayplan_entry.exdrawamount");
        sic.add("repayplan_entry.erepayamount");
        sic.add("repayplan_entry.repaystate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection repayplanEntryDC = dataEntity.getDynamicObjectCollection("repayplan_entry");
            DynamicObject[] repayPlans = (DynamicObject[])repayplanEntryDC.toArray((Object[])new DynamicObject[0]);
            for (int i = 0; i < repayPlans.length - 1; ++i) {
                for (int j = 0; j < repayPlans.length - i - 1; ++j) {
                    Date nextdate;
                    Date date = repayPlans[j].getDate("exrepaymentdate");
                    if (!date.after(nextdate = repayPlans[j + 1].getDate("exrepaymentdate"))) continue;
                    this.operationResult.setMessage(new BizResourceFactory().getBizResource("").getLbSCheduleSaveCheck());
                    DynamicObject temp = repayPlans[j];
                    repayPlans[j] = repayPlans[j + 1];
                    repayPlans[j + 1] = temp;
                }
            }
            for (int k = 0; k < repayPlans.length; ++k) {
                repayPlans[k].set("enotrepayamount", (Object)repayPlans[k].getBigDecimal("exdrawamount").subtract(repayPlans[k].getBigDecimal("erepayamount")));
                repayPlans[k].set("seq", (Object)(k + 1));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List loanBillIds = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toList());
        LoanWriteBackHelper.writeBack(loanBillIds, (LoanWBTypeEnum)LoanWBTypeEnum.UPDATEAMOUNT);
    }
}

