/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.repository.LoanContractBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;

public class LoanBillSumbitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("notrepayamount");
        sic.add("creditlimit");
        sic.add("billno");
        sic.add("datasource");
        sic.add("org");
        sic.add("creditorg");
        sic.add("registorg");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("returnreason");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("issetpluspoint");
        sic.add("condition_entry_er");
        sic.add("startintdate");
        sic.add("term");
        sic.add("convertrate");
        sic.add("loancontractbill");
        sic.add("issofrrate");
        sic.add("iscallcompint");
        sic.add("intcalmethod");
        sic.add("workcalendar");
        sic.add("rateresetadjustrule");
        sic.add("accountbank");
        sic.add("drawamount");
        sic.add("bizdate");
        sic.add("expiredate");
        sic.add("stageplan");
        sic.add("repaymentway");
        sic.add("currency");
        sic.add("currency.amtprecision");
        sic.add("productfactory");
        sic.add("fixedRepayAmount");
        sic.add("loancontractbill");
        sic.add("repayplan_entry");
        sic.add("repayplan_entry.exrepaymentdate");
        sic.add("repayplan_entry.exdrawamount");
        sic.add("repayplan_entry.erepayamount");
        sic.add("repayplan_entry.enotrepayamount");
        sic.add("repayplan_entry.repayaccount");
        sic.add("repayplan_entry.repaymentmodifier");
        sic.add("repayplan_entry.repaymentmodifytime");
        sic.add("repayplan_entry.seq");
        sic.add("repayplan_entry.repaystate");
        sic.add("eassrcid");
        sic.add("isnofixedterm");
        sic.add("banksyndicate_entry");
        sic.add("workcalendar");
        sic.add("banksyndicate_entry.e_bankcreditlimit");
        sic.add("loancontractbill.amount");
        sic.add("loancontractbill.iscycleloan");
        return sic;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        CfmBillCommonHelper.dealNoTermInfo(dataEntities);
        LoanBillRepayPlanHelper.autoGenRepayPlan(dataEntities);
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        Map loanApplyBillMap = BusinessHelper.getLoanApplyBill(Arrays.asList(dataEntities));
        for (DynamicObject data : dataEntities) {
            BusinessHelper.clearReturnreason((DynamicObject)data);
            data.set("notrepayamount", (Object)data.getBigDecimal("drawamount"));
            DynamicObject applybill = (DynamicObject)loanApplyBillMap.get(data.getLong("id"));
            String loanType = data.getString("loantype");
            if (LoanTypeEnum.isBanksLoan((String)loanType)) {
                CreditLimitHelper.creditBizSubmit((DynamicObject)data, (DynamicObject)applybill, (String)"banksyndicate_entry", (String)"e_bankcreditlimit");
            } else {
                CreditLimitHelper.creditBizSubmit((DynamicObject)data, (DynamicObject)applybill, null, null);
            }
            if (LoanBillHelper.isBond((DynamicObject)data)) continue;
            data.set("term", (Object)DateUtils.getDiff_ymd((Date)data.getDate("startintdate"), (Date)data.getDate("expiredate")));
        }
        this.updateNotDrawAmount(dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List loanBillIds = Arrays.stream(dataEntities).map(l -> l.getLong("id")).collect(Collectors.toList());
        LoanWriteBackHelper.writeBack(loanBillIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
    }

    private void updateNotDrawAmount(DynamicObject[] dataEntities) {
        Map<Long, List<DynamicObject>> contractMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> d.getLong("loancontractbill.id")));
        Map canDrawAmountMap = LoanContractBillRepository.getContractBillDrawAmountSum(new ArrayList<Long>(contractMap.keySet()));
        for (Map.Entry<Long, List<DynamicObject>> entry : contractMap.entrySet()) {
            for (DynamicObject loanBill : entry.getValue()) {
                ContractBillAmountSumDTO dto = (ContractBillAmountSumDTO)canDrawAmountMap.get(entry.getKey());
                if (dto == null) continue;
                loanBill.set("notdrawamount", (Object)dto.getUnDrawAmt());
            }
        }
    }
}

