/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.helper.UnifyLoanRepayHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("drawtype");
        sic.add("creditlimit");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("loancontractbill");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("settlestatus");
        sic.add("bizdate");
        sic.add("billno");
        sic.add("loantype");
        sic.add("bankcheckflag");
        sic.add("bitbackinfo");
        sic.add("payedintamount");
        sic.add("convertdrawamt");
        sic.add("convertrate");
        sic.add("calculaterateamount");
        sic.add("notrepayamount");
        sic.add("isunifyloanreturn");
        sic.add("unifyloanfrom_entry");
        sic.add("unifyloanfrom_entry.e_loanbillid");
        sic.add("unifyloanfrom_entry.e_useamt");
        sic.add("unifyloanfrom_entry.e_payamt");
        sic.add("unifyloanfrom_entry.e_notpayint");
        sic.add("unifyloanfrom_entry.e_payint");
        sic.add("unifyloanfrom_entry.e_useloanamt");
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.e_bankcreditlimit");
        sic.add("drawapplybill");
        sic.add("datasource");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            CfmBillCommonHelper.updateApplyBizStatus((DynamicObject)dataEntity, (String)"drawapplybill", (String)"cfm_draw_apply", (String)ApplyBusinessStatusEnum.HANDING.getValue());
            String loanType = dataEntity.getString("loantype");
            if (!LoanTypeEnum.isBanksLoan((String)loanType) && EmptyUtil.isNoEmpty((DynamicObject)dataEntity.getDynamicObject("creditlimit"))) {
                DynamicObject bizBill = dataEntity;
                String fields = dataEntity.getDataEntityType().getProperties().parallelStream().map(o -> o.getName()).collect(Collectors.joining(","));
                if (this.getOperationVariable().containsKey("back")) {
                    String entityName = "cfm_loanbill".equals(bizBill.getDataEntityType().getName()) ? "cim_invest_loanbill" : "cfm_loanbill";
                    bizBill = TmcDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)entityName, (String)fields);
                }
                CreditLimitHelper.creditBizUnSubmit((DynamicObject)bizBill);
            } else if (LoanTypeEnum.isBanksLoan((String)loanType)) {
                CreditLimitHelper.creditBizUnSubmit((DynamicObject)dataEntity);
            }
            dataEntity.set("drawtype", (Object)DrawTypeEnum.DRAWING.getValue());
            if (EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("back")))) {
                BusinessHelper.clearConfirmInfoForUnAudit((DynamicObject)dataEntity);
                UnifyLoanRepayHelper.removeRelateLink((DynamicObject[])new DynamicObject[]{dataEntity});
            } else {
                BusinessHelper.clearConfirmInfoForBack((DynamicObject)dataEntity);
            }
            String creditorType = dataEntity.getString("creditortype");
            if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) continue;
            String entityName = dataEntity.getDataEntityType().getName();
            if ("cfm_loanbill".equals(entityName)) {
                dataEntity.set("settlestatus", (Object)"");
                dataEntity.set("bitbackinfo", null);
                continue;
            }
            dataEntity.set("settlestatus", (Object)SettleCenterStatusEnum.ADDNEW.getValue());
            dataEntity.set("bankcheckflag", null);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.buildLoanBill(Arrays.asList(dataEntities), (LoanWBTypeEnum)LoanWBTypeEnum.UPDATECONTRACT));
    }
}

