/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillUpdateRateResetDaysService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(LoanBillUpdateRateResetDaysService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("rateresetdays");
        sic.add("productfactory");
        sic.add("startintdate");
        sic.add("rateadjustdate");
        sic.add("productfactory");
        sic.add("loancontractbill");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> needUpdateLoanBill = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject loanbill : dataEntities) {
            int rateResetDays = loanbill.getInt("rateresetdays");
            boolean isSofr = LoanBillHelper.isSofr((DynamicObject)loanbill);
            DynamicObject productFactory = loanbill.getDynamicObject("productfactory");
            if (isSofr && EmptyUtil.isEmpty((Integer)rateResetDays)) {
                Date actStartIntDate = loanbill.getDate("startintdate");
                Date rateAdjustDate = loanbill.getDate("rateadjustdate");
                if (!EmptyUtil.isNoEmpty((Object)rateAdjustDate) || !EmptyUtil.isNoEmpty((Object)actStartIntDate)) continue;
                DynamicObject contractBillF7 = loanbill.getDynamicObject("loancontractbill");
                DynamicObjectCollection workCalendar = contractBillF7.getDynamicObjectCollection("workcalendar");
                Long[] wcIds = workCalendar.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
                rateResetDays = CfmBillCommonHelper.getWorkDayCount((Long[])wcIds, (Date)rateAdjustDate, (Date)actStartIntDate);
                logger.info("LoanBillUpdateRateResetDaysService:sofr:diffDays" + rateResetDays);
                loanbill.set("rateresetdays", (Object)rateResetDays);
                needUpdateLoanBill.add(loanbill);
                continue;
            }
            if (!EmptyUtil.isEmpty((Integer)rateResetDays) || !EmptyUtil.isNoEmpty((DynamicObject)productFactory)) continue;
            rateResetDays = productFactory.getInt("rateresetdays");
            logger.info("LoanBillUpdateRateResetDaysService:ProductFactoryProp.rateresetdays:diffDays" + rateResetDays);
            loanbill.set("rateresetdays", (Object)rateResetDays);
            needUpdateLoanBill.add(loanbill);
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateLoanBill.toArray(new DynamicObject[0]));
    }
}

