/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.operate.InterestBillOperate;
import kd.tmc.cfm.common.operate.LoanBillOperate;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanBillYkxServiceHelper {
    public static final String OP_VAR_YKX = "ykx_fromLoanBill";
    private static final Log log = LogFactory.getLog(LoanBillYkxServiceHelper.class);

    public static OperationResult auditLoanBillForYkx(DynamicObject loanBill) {
        if (LoanBillYkxServiceHelper.checkIsYkx(loanBill)) {
            return null;
        }
        long loanBillId = loanBill.getLong("id");
        log.info("\u5f00\u59cb\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        DynamicObjectCollection intEntry = loanBill.getDynamicObjectCollection("interest_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intEntry)) {
            log.info("\u4ed8\u606f\u8ba1\u5212\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
            return null;
        }
        DynamicObjectCollection intBills = InterestBillRepository.queryPrePayInterestBills(Collections.singletonList(loanBillId), (boolean)Boolean.FALSE);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)intBills)) {
            log.info("\u5df2\u7ecf\u751f\u6210\u8fc7\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
            DynamicObject interestBill = (DynamicObject)intBills.get(0);
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, interestBill.getBigDecimal("actualinstamt"), interestBill.getDate("endinstdate"));
            return LoanBillYkxServiceHelper.getSuccessOperationResult();
        }
        boolean isSettler = false;
        String loanType = loanBill.getString("loantype");
        String dataSource = loanBill.getString("datasource");
        Pair intBotpPair = BatchIntBillHelper.getIntBotpPair((String)loanType, (String)dataSource);
        if (loanBill.getDataEntityType().getName().equals("ifm_loanbill")) {
            intBotpPair = Pair.of((Object)"ifm_loanbill", (Object)"ifm_interestbill");
            isSettler = loanBill.getString("creditortype").equals(CreditorTypeEnum.SETTLECENTER.getValue());
        }
        DynamicObject sourceBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((String)intBotpPair.getLeft())));
        sourceBill.set("id", (Object)loanBill.getLong("id"));
        DynamicObject[] interestBills = TmcBotpHelper.push((DynamicObject)sourceBill, (String)((String)intBotpPair.getRight()));
        DynamicObject interestBill = interestBills[0];
        DynamicObject intPlan = (DynamicObject)intEntry.get(0);
        interestBill.set("instbillctg", (Object)InterestbillctgEnum.PREPAYINT.getValue());
        interestBill.set("bizdate", (Object)loanBill.getDate("bizdate"));
        BigDecimal intAmt = intPlan.getBigDecimal("interestcalamount");
        interestBill.set("actualinstamt", (Object)intAmt);
        DynamicObjectCollection intPlanEntrys = intPlan.getDynamicObjectCollection("interest_subentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)intPlanEntrys)) {
            log.info("\u4ed8\u606f\u8ba1\u5212\u7684\u6d4b\u7b97\u660e\u7ec6\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
            return null;
        }
        Date intEndDate = intPlan.getDate("intenddate");
        interestBill.set("endinstdate", (Object)intEndDate);
        interestBill.set("predictinstamt", (Object)intAmt);
        interestBill.set("convertrate", (Object)BigDecimal.ONE);
        interestBill.set("convertintamt", (Object)intAmt);
        DynamicObjectCollection entrys = interestBill.getDynamicObjectCollection("entrys");
        for (DynamicObject intPlanEntry : intPlanEntrys) {
            LoanBillYkxServiceHelper.buildIntPlanEntry(intPlanEntry, entrys);
        }
        log.info("\u5f00\u59cb\u63d0\u4ea4\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        OperateOption option = LoanBillYkxServiceHelper.getOperateOption(loanBillId);
        OperationResult opResult = InterestBillOperate.submit((DynamicObject[])interestBills, (OperateOption)option);
        log.info("\u7ed3\u675f\u63d0\u4ea4\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u63d0\u4ea4\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (!LoanBillYkxServiceHelper.isSuccess(opResult)) {
            return opResult;
        }
        Object interestBillId = opResult.getSuccessPkIds().toArray()[0];
        log.info("\u5f00\u59cb\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        opResult = InterestBillOperate.audit((Object[])new Object[]{interestBillId}, (OperateOption)option);
        log.info("\u7ed3\u675f\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u5ba1\u6838\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (LoanBillYkxServiceHelper.isSuccess(opResult)) {
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, intAmt, intEndDate);
        }
        if (isSettler) {
            TmcBotpHelper.saveRelation((String)"cfm_loanbill", (Long)loanBillId, (String)interestBill.getDataEntityType().getName(), (Long)((Long)interestBillId));
        }
        log.info("\u7ed3\u675f\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}, interestBillId: {}", (Object)loanBillId, interestBillId);
        return opResult;
    }

    private static DynamicObject buildIntPlanEntry(DynamicObject intPlanEntry, DynamicObjectCollection entrys) {
        DynamicObject intDetail = entrys.addNew();
        intDetail.set("seq", (Object)1);
        intDetail.set("inststartdate", intPlanEntry.get("intereststartdate"));
        intDetail.set("instenddate", (Object)intPlanEntry.getDate("interestenddate"));
        intDetail.set("instdays", intPlanEntry.get("interestdate"));
        intDetail.set("instprincipalamt", intPlanEntry.get("interestbalance"));
        intDetail.set("rate", intPlanEntry.get("interestrate"));
        intDetail.set("ratetrandays", intPlanEntry.get("interestdays"));
        intDetail.set("instamt", intPlanEntry.get("interestamount"));
        intDetail.set("instctg", intPlanEntry.get("interestway"));
        intDetail.set("floatrate", intPlanEntry.get("floatrate"));
        intDetail.set("floatint", intPlanEntry.get("floatint"));
        intDetail.set("totalint", intPlanEntry.get("interestamount"));
        intDetail.set("lasttotalint", intPlanEntry.get("lasttotalint"));
        intDetail.set("curtotalint", intPlanEntry.get("curtotalint"));
        intDetail.set("confirmratedate", intPlanEntry.get("confirmratedate"));
        intDetail.set("lookdays", intPlanEntry.get("lookdays"));
        return intDetail;
    }

    private static void updateLoanBill(DynamicObject loanBill, BigDecimal intAmt, Date endIntDate) {
        loanBill.set("payedintamount", (Object)intAmt);
        loanBill.set("endinstdate", (Object)endIntDate);
    }

    public static OperationResult rollbackLoanBillForYkx(DynamicObject loanBill) {
        if (LoanBillYkxServiceHelper.checkIsYkx(loanBill)) {
            return null;
        }
        long loanBillId = loanBill.getLong("id");
        log.info("\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355\u5931\u8d25,\u5f00\u59cb\u53cd\u5ba1\u6838\u63d0\u6b3e\u5355: loanbillId:{}", (Object)loanBillId);
        OperateOption option = LoanBillYkxServiceHelper.getOperateOption(loanBillId);
        if (InterestBillRepository.isExistByLoanBillId((Long)loanBillId)) {
            log.info("\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355\u5931\u8d25,\u53cd\u5ba1\u6838\u63d0\u6b3e\u5355\u7ed3\u679c:\u5229\u606f\u5355\u5df2\u7ecf\u751f\u6210, loanbillId: {}", (Object)loanBillId);
            return null;
        }
        OperationResult opResult = LoanBillOperate.unaudit((Object[])new Object[]{loanBillId}, (OperateOption)option);
        log.info("\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355\u5931\u8d25,\u7ed3\u675f\u53cd\u5ba1\u6838\u63d0\u6b3e\u5355,\u53cd\u5ba1\u6838\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (LoanBillYkxServiceHelper.isSuccess(opResult)) {
            log.info("\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355\u5931\u8d25,\u5f00\u59cb\u53cd\u5ba1\u6838\u540e\u63d0\u4ea4\u63d0\u6b3e\u5355: loanbillId:{}", (Object)loanBillId);
            opResult = LoanBillOperate.submit((Object[])new Object[]{loanBillId}, (OperateOption)option);
            log.info("\u751f\u6210\u9884\u6263\u606f\u5229\u606f\u5355\u5931\u8d25,\u53cd\u5ba1\u6838\u540e\u63d0\u4ea4\u63d0\u6b3e\u5355,\u63d0\u4ea4\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        }
        return opResult;
    }

    private static boolean checkIsYkx(DynamicObject loanBill) {
        if (!LoanBillHelper.isYkx((DynamicObject)loanBill)) {
            return true;
        }
        return !ConfirmStatusEnum.isYetconfirm((String)loanBill.getString("confirmstatus"));
    }

    public static OperationResult confirmLoanBillForYkx(DynamicObject loanBill) {
        Object[] interestBillIds;
        Object[] recTransBills;
        long loanBillId = loanBill.getLong("id");
        DynamicObjectCollection interestBills = InterestBillRepository.queryPrePayInterestBills(Collections.singletonList(loanBillId), (boolean)Boolean.FALSE);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestBills)) {
            return null;
        }
        if (loanBill.getString("creditortype").equals(CreditorTypeEnum.SETTLECENTER.getValue()) && EmptyUtil.isNoEmpty((Object[])(recTransBills = BusinessDataServiceHelper.load((String)"ifm_rectransbill", (String)"actrecamt", (QFilter[])new QFilter("sourcebillid", "=", (Object)loanBillId).toArray())))) {
            recTransBills[0].set("actrecamt", (Object)loanBill.getBigDecimal("drawamount").subtract(loanBill.getBigDecimal("payedintamount")));
            SaveServiceHelper.update((DynamicObject[])recTransBills);
        }
        if (EmptyUtil.isEmpty((Object[])(interestBillIds = interestBills.stream().filter(i -> !ConfirmStatusEnum.isYetconfirm((String)i.getString("confirmstatus"))).map(i -> i.getLong("id")).collect(Collectors.toList()).toArray(new Long[0])))) {
            return LoanBillYkxServiceHelper.getSuccessOperationResult();
        }
        log.info("\u5f00\u59cb\u786e\u8ba4\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        OperateOption option = LoanBillYkxServiceHelper.getOperateOption(loanBillId);
        OperationResult opResult = InterestBillOperate.businessConfirm((Object[])interestBillIds, (OperateOption)option);
        log.info("\u7ed3\u675f\u786e\u8ba4\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u5ba1\u6838\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        return opResult;
    }

    public static OperationResult unAuditLoanBillForYkx(DynamicObject loanBill) {
        if (!LoanBillHelper.isYkx((DynamicObject)loanBill)) {
            return null;
        }
        long loanBillId = loanBill.getLong("id");
        DynamicObjectCollection interestBills = InterestBillRepository.queryPrePayInterestBills(Collections.singletonList(loanBillId), (boolean)Boolean.FALSE);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestBills)) {
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, BigDecimal.ZERO, null);
            return LoanBillYkxServiceHelper.getSuccessOperationResult();
        }
        OperateOption option = LoanBillYkxServiceHelper.getOperateOption(loanBillId);
        Object[] interestBillIds = interestBills.stream().map(i -> i.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
        log.info("\u5f00\u59cb\u53cd\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        OperationResult opResult = InterestBillOperate.unaudit((Object[])interestBillIds, (OperateOption)option);
        log.info("\u7ed3\u675f\u53cd\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u53cd\u5ba1\u6838\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (!LoanBillYkxServiceHelper.isSuccess(opResult)) {
            return opResult;
        }
        log.info("\u5f00\u59cb\u5220\u9664\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        opResult = InterestBillOperate.delete((Object[])interestBillIds, (OperateOption)option);
        log.info("\u7ed3\u675f\u5220\u9664\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u5220\u9664\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (LoanBillYkxServiceHelper.isSuccess(opResult)) {
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, BigDecimal.ZERO, null);
        }
        return opResult;
    }

    public static OperationResult unConfirmLoanBillForYkx(DynamicObject loanBill) {
        if (!LoanBillHelper.isYkx((DynamicObject)loanBill)) {
            return null;
        }
        long loanBillId = loanBill.getLong("id");
        DynamicObjectCollection interestBills = InterestBillRepository.queryPrePayInterestBills(Collections.singletonList(loanBillId), (boolean)Boolean.TRUE);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestBills)) {
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, BigDecimal.ZERO, null);
            return LoanBillYkxServiceHelper.getSuccessOperationResult();
        }
        OperateOption option = LoanBillYkxServiceHelper.getOperateOption(loanBillId);
        log.info("\u5f00\u59cb\u53d6\u6d88\u786e\u8ba4\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        Object[] interestBillIds = interestBills.stream().map(i -> i.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
        log.info("\u5f00\u59cb\u53cd\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        OperationResult opResult = InterestBillOperate.unaudit((Object[])interestBillIds, (OperateOption)option);
        log.info("\u7ed3\u675f\u53cd\u5ba1\u6838\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u53cd\u5ba1\u6838\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (!LoanBillYkxServiceHelper.isSuccess(opResult)) {
            return opResult;
        }
        log.info("\u5f00\u59cb\u5220\u9664\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355, loanbillId: {}", (Object)loanBillId);
        opResult = InterestBillOperate.delete((Object[])interestBillIds, (OperateOption)option);
        log.info("\u7ed3\u675f\u5220\u9664\u751f\u6210\u7684\u9884\u6263\u606f\u5229\u606f\u5355,\u5220\u9664\u7ed3\u679c: {}, loanbillId: {}", (Object)opResult, (Object)loanBillId);
        if (LoanBillYkxServiceHelper.isSuccess(opResult)) {
            LoanBillYkxServiceHelper.updateLoanBill(loanBill, BigDecimal.ZERO, null);
        }
        return opResult;
    }

    private static OperationResult getSuccessOperationResult() {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        return result;
    }

    private static OperateOption getOperateOption(long loanBillId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        option.setVariableValue(OP_VAR_YKX, String.valueOf(loanBillId));
        return option;
    }

    public static boolean isSuccess(OperationResult opResult) {
        return opResult != null && opResult.isSuccess();
    }

    public static boolean isYkxOp(OperateOption option) {
        return option.containsVariable(OP_VAR_YKX);
    }
}

