/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.SyncDrawHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractAuditSyncDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LoanContractAuditSyncDrawService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("confirmstatus");
        sic.add("lendernature");
        sic.add("contractstatus");
        sic.add("creditorg");
        sic.add("org");
        sic.add("sourcebillid");
        sic.add("lenderapplyno");
        sic.add("datasource");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("productfactory");
        sic.add("settlestatus");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("loantype");
        sic.add("issyncdraw");
        sic.add("drawway");
        sic.add("isinit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        this.handleSyncDraw(dataEntities);
    }

    private void handleSyncDraw(DynamicObject[] dataEntities) {
        try {
            for (DynamicObject loanContract : dataEntities) {
                if (!this.isCanSyncDraw(loanContract)) continue;
                SyncDrawHelper.handleSyncDraw((DynamicObject)loanContract);
            }
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6838\u65f6\u540c\u6b65\u63d0\u6b3e\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private boolean isCanSyncDraw(DynamicObject loancontract) {
        boolean isBank;
        if (!loancontract.getBoolean("issyncdraw")) {
            return false;
        }
        String entityName = loancontract.getDataEntityType().getName();
        String loanType = loancontract.getString("loantype");
        String creditorType = loancontract.getString("creditortype");
        boolean isCimInvestContract = entityName.equals("cim_invest_contract");
        boolean isCfmLoanContract = entityName.equals("cfm_loancontractbill");
        String creditorOrDebtorType = isCfmLoanContract ? creditorType : (isCimInvestContract ? loancontract.getString("debtortype") : creditorType);
        boolean isOutgroupType = CreditorTypeEnum.CUSTOM.getValue().equals(creditorOrDebtorType) || CreditorTypeEnum.OTHER.getValue().equals(creditorOrDebtorType);
        boolean outerGroup = isOutgroupType && (isCfmLoanContract || isCimInvestContract);
        boolean isYetconfirm = ConfirmStatusEnum.isYetconfirm((String)loancontract.getString("confirmstatus"));
        boolean bl = isBank = LoanTypeEnum.isFinLease((String)loanType) || LoanTypeEnum.isBankLoan((String)loanType) || LoanTypeEnum.isBanksLoan((String)loanType) || (LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isEntrustLoan((String)loanType)) && outerGroup;
        if (isYetconfirm && isBank) {
            return true;
        }
        if ("ifm_loancontractbill".equals(entityName)) {
            return this.isInnerContract(loancontract);
        }
        return false;
    }

    private boolean isInnerContract(DynamicObject loancontract) {
        QFilter qFilter = new QFilter("id", "=", loancontract.getPkValue());
        DynamicObject contractBill = QueryServiceHelper.queryOne((String)loancontract.getDataEntityType().getName(), (String)"id,confirmstatus", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)contractBill)) {
            return ConfirmStatusEnum.isYetconfirm((String)contractBill.getString("confirmstatus"));
        }
        return false;
    }

    public void afterProcessRollback(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject loanContract : dataEntities) {
            if (!this.isCanSyncDraw(loanContract)) continue;
            SyncDrawHelper.unsubmitAndDeleteLoanBill((DynamicObject)loanContract);
            SyncDrawHelper.unauditAndSubmitLoanContract((DynamicObject)loanContract);
        }
    }
}

