/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractAutoClosedService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("billstatus");
        sic.add("contractstatus");
        sic.add("datasource");
        sic.add("iscycleloan");
        sic.add("creditlimit");
        sic.add("amount");
        sic.add("repayamount");
        sic.add("enddate");
        sic.add("renewalexpiredate");
        sic.add("ishandend");
        sic.add("drawamount");
        sic.add("lenderapplyno");
        sic.add("loantype");
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.e_creditlimit");
        sic.add("banksyndicate_entry.e_creditamt");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject contractBill : dataEntities) {
            if (!contractBill.getBoolean("iscycleloan")) continue;
            String contractStatus = contractBill.getString("contractstatus");
            if (!StringUtils.equals((CharSequence)LoanContractStatusEnum.EXECUTING.getValue(), (CharSequence)contractStatus)) continue;
            Date endDate = contractBill.getDate("enddate");
            Date renewalexpireDate = contractBill.getDate("renewalexpiredate");
            Date date = endDate = renewalexpireDate == null ? endDate : renewalexpireDate;
            if (endDate.compareTo(new Date()) > 0) continue;
            BigDecimal contractLoanAmt = contractBill.getBigDecimal("amount");
            BigDecimal contractRepayAmount = contractBill.getBigDecimal("repayamount");
            QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
            DynamicObjectCollection downLoanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,drawtype", (QFilter[])qFilter.toArray());
            boolean isAllCloseLoanBill = true;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)downLoanBills)) {
                isAllCloseLoanBill = downLoanBills.stream().allMatch(o -> DrawTypeEnum.CLOSEOUT.getValue().equals(o.getString("drawtype")));
            }
            if (!isAllCloseLoanBill || contractRepayAmount.compareTo(contractLoanAmt) < 0) continue;
            OperationServiceHelper.executeOperate((String)"endcontract", (String)contractBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{contractBill}, (OperateOption)OperateOption.create());
        }
    }
}

