/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanContractBillEndService
extends AbstractTmcBizOppService {
    private static final String COMMA_CHAR = ",";
    private static final String PERIOD_CHAR = ".";
    private static final String[] LOAN_APPLY_PROP = new String[]{"id", "billno", "amount", "creditlimit"};
    private static final String[] LOAN_BOND_PROP = new String[]{"id", "drawtype", "ishandend", "creditlimit", "drawamount", "occupybondlimit", "closeoffdate", String.join((CharSequence)".", "investor_entry", "e_creditlimit"), String.join((CharSequence)".", "investor_entry", "e_creditamt"), String.join((CharSequence)".", "investor_entry", "e_investamount")};
    private static final String[] CFM_LOAN_PROP = new String[]{"id", "drawtype", "ishandend", "datasource", "creditlimit", "closeoffdate", "drawamount"};

    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("contractstatus");
        sl.add("ishandend");
        sl.add("creditlimit");
        sl.add("drawamount");
        sl.add("lenderapplyno");
        sl.add("loantype");
        sl.add("amount");
        sl.add("closeoffdate");
        sl.add("issyncdraw");
        sl.add("banksyndicate_entry");
        sl.add("banksyndicate_entry.e_creditlimit");
        sl.add("banksyndicate_entry.e_creditamt");
        return sl;
    }

    public void process(DynamicObject[] contractBills) throws KDException {
        for (DynamicObject info : contractBills) {
            boolean creditLimitFlag = false;
            if (null != info.get("creditlimit")) {
                this.returnCreditLimit(info);
                creditLimitFlag = true;
            } else if (LoanTypeEnum.BANKSLOAN.getValue().equals(info.get("loantype"))) {
                creditLimitFlag = this.returnBanksLoanCreditLimit(info);
            } else {
                this.returnLoanApplyCreditLimit(info);
            }
            info.set("contractstatus", (Object)LoanContractStatusEnum.CLOSED.getValue());
            info.set("closeoffdate", (Object)new Date());
            info.set("ishandend", (Object)true);
            this.dealDownLoadBill(info, creditLimitFlag);
        }
        SaveServiceHelper.save((DynamicObject[])contractBills);
    }

    private boolean returnBanksLoanCreditLimit(DynamicObject contract) {
        boolean isConcreditUse;
        DynamicObjectCollection bankEntries = contract.getDynamicObjectCollection("banksyndicate_entry");
        List entryCredList = bankEntries.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(entryCredList)) {
            return false;
        }
        boolean isSynLoan = contract.getBoolean("issyncdraw");
        if (isSynLoan && !(isConcreditUse = CreditLimitHelper.isCreditUse((long)contract.getLong("id"), null))) {
            return false;
        }
        HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(entryCredList.size());
        for (DynamicObject entryCred : entryCredList) {
            entryReturnAmtMap.put(entryCred.getLong("id"), entryCred.getBigDecimal("e_creditamt"));
        }
        ReturnCreditLimitInfo returnInfo = this.getReturnInfo(contract);
        returnInfo.setId(Long.valueOf(contract.getLong("id")));
        returnInfo.setEntityName(contract.getDataEntityType().getName());
        returnInfo.setLast(true);
        returnInfo.setReturnBillId(Long.valueOf(contract.getLong("id")));
        returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
        CreditLimitServiceHelper.returnCreditLimit((ReturnCreditLimitInfo)returnInfo);
        return true;
    }

    private void returnLoanApplyCreditLimit(DynamicObject bill) {
        String lenderApplyNo = bill.getString("lenderapplyno");
        if (StringUtils.isEmpty((CharSequence)lenderApplyNo)) {
            return;
        }
        DynamicObject loanApply = TmcDataServiceHelper.loadSingle((String)"cfm_loan_apply", (String)String.join((CharSequence)COMMA_CHAR, LOAN_APPLY_PROP), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)lenderApplyNo)});
        if (null != loanApply.get("creditlimit")) {
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)bill, (DynamicObject)loanApply, (boolean)true, (BigDecimal)loanApply.getBigDecimal("amount"), (Long)bill.getLong("id"));
        }
    }

    private void dealDownLoadBill(DynamicObject contractBill, boolean creditLimitFlag) {
        Object[] downLoanBills = this.getDrawBill(contractBill);
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(downLoanBills.length);
        for (Object bill : downLoanBills) {
            bill.set("drawtype", (Object)DrawTypeEnum.CLOSEOUT.getValue());
            bill.set("closeoffdate", (Object)DateUtils.getCurrentDate());
            bill.set("ishandend", (Object)true);
            if (StringUtils.equals((CharSequence)bill.getDataEntityType().getName(), (CharSequence)"cfm_loanbill_bond")) {
                this.dealBondLimit((DynamicObject)bill, paramList);
                continue;
            }
            if (creditLimitFlag || null == bill.get("creditlimit")) continue;
            this.dealDownLoanLimit((DynamicObject)bill, paramList);
        }
        if (EmptyUtil.isNoEmpty((Object[])downLoanBills)) {
            SaveServiceHelper.save((DynamicObject[])downLoanBills);
        }
        if (EmptyUtil.isNoEmpty(paramList)) {
            CreditLimitServiceHelper.batchRreturnCreditLimit(paramList);
        }
    }

    private void dealDownLoanLimit(DynamicObject bill, List<ReturnCreditLimitInfo> returnCreditLimitList) {
        ReturnCreditLimitInfo returnInfo = this.getReturnInfo(bill);
        returnInfo.setId(Long.valueOf(bill.getLong("id")));
        returnInfo.setEntityName(LoanContractBillEndService.getLoanEntityName(bill.getString("datasource")));
        DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)bill.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
            returnInfo.setEntityName(creditUseBill.getString("sourcetype"));
        }
        returnInfo.setLast(true);
        returnInfo.setReturnBillId(Long.valueOf(bill.getLong("id")));
        returnInfo.setReturnAmt(bill.getBigDecimal("drawamount"));
        returnCreditLimitList.add(returnInfo);
    }

    private static String getLoanEntityName(String dataSource) {
        HashMap<String, String> entityMap = new HashMap<String, String>();
        entityMap.put(DataSourceEnum.CFM.getValue(), "cfm_loanbill");
        entityMap.put(DataSourceEnum.INVEST.getValue(), "cim_invest_loanbill");
        entityMap.put(DataSourceEnum.IFM.getValue(), "ifm_loanbill");
        return (String)entityMap.get(dataSource);
    }

    private void dealBondLimit(DynamicObject bill, List<ReturnCreditLimitInfo> returnCreditLimitList) {
        DynamicObject limit = bill.getDynamicObject("occupybondlimit");
        if (null != limit && StringUtils.equals((CharSequence)"loop", (CharSequence)limit.getString("limittype"))) {
            BondLimitHelper.changeLimitOnDelete((DynamicObject)bill, (Object)bill.getDynamicObject("occupybondlimit").getPkValue());
        }
        this.dealBondCreditLimit(bill, returnCreditLimitList);
    }

    private void dealBondCreditLimit(DynamicObject bill, List<ReturnCreditLimitInfo> returnCreditLimitList) {
        DynamicObjectCollection investEntries = bill.getDynamicObjectCollection("investor_entry");
        List entryCredList = investEntries.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(entryCredList)) {
            return;
        }
        HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(entryCredList.size());
        for (DynamicObject entryCred : entryCredList) {
            entryReturnAmtMap.put(entryCred.getLong("id"), entryCred.getBigDecimal("e_investamount"));
        }
        ReturnCreditLimitInfo returnInfo = this.getReturnInfo(bill);
        returnInfo.setId(Long.valueOf(bill.getLong("id")));
        returnInfo.setEntityName(bill.getDataEntityType().getName());
        returnInfo.setLast(true);
        returnInfo.setReturnBillId(Long.valueOf(bill.getLong("id")));
        returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
        returnCreditLimitList.add(returnInfo);
    }

    private ReturnCreditLimitInfo getReturnInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setPreOccupy(false);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setBizBillId((Long)bill.getPkValue());
        param.setReturnTime(DateUtils.getCurrentDate());
        return param;
    }

    private DynamicObject[] getDrawBill(DynamicObject contractBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue()).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        if (StringUtils.equals((CharSequence)contractBill.getDataEntityType().getName(), (CharSequence)"cfm_loancontract_bo")) {
            return TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)String.join((CharSequence)COMMA_CHAR, LOAN_BOND_PROP), (QFilter[])qFilter.toArray());
        }
        return TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)COMMA_CHAR, CFM_LOAN_PROP), (QFilter[])qFilter.toArray());
    }

    private void returnCreditLimit(DynamicObject bill) {
        CreditLimitServiceHelper.returnCreditLimit((DynamicObject)bill, (DynamicObject)bill, (boolean)false, (BigDecimal)bill.getBigDecimal("drawamount"), (Long)bill.getLong("id"), (boolean)true, (Date)DateUtils.getCurrentDate());
    }
}

