/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.constant.CfmEntityConst;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillUnAuditService
extends AbstractTmcBizOppService {
    private final String[] GUARANTEE_USE_PROPS = new String[]{"gsrcbillid", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gcreditortype", "gcreditor", "gcreditortext"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loantype");
        sic.add("confirmstatus");
        sic.add("contractstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("datasource");
        sic.add("lendernature");
        sic.add("org");
        sic.add("creditorg");
        sic.add("sourcebillid");
        sic.add("lenderapplyno");
        sic.add("textdebtor");
        sic.add("datasource");
        sic.add("textdebtor");
        sic.add("productfactory");
        sic.add("creditlimit");
        sic.add("loanapply");
        sic.add("creditortype");
        sic.add("creditor");
        sic.add("textcreditor");
        sic.add("settlestatus");
        sic.add("e_creditlimit");
        sic.add("debtortype");
        sic.add("startdate");
        sic.add("bizdate");
        sic.add("billno");
        sic.add("synccreditlimit");
        sic.add("amount");
        sic.add("enddate");
        sic.add("currency");
        sic.add("issyncdraw");
        sic.add("syncdrawamount");
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.e_bankrole");
        sic.add("banksyndicate_entry.e_bank");
        sic.add("banksyndicate_entry.e_creditlimit");
        sic.add("banksyndicate_entry.e_loanamount");
        sic.add("banksyndicate_entry.e_shareamount");
        sic.add("entry_gcontract");
        sic.add("entry_gcontract.gcontract");
        sic.add("entry_gcontract.gamount");
        sic.add("entry_gcontract.gratio");
        sic.add("entry_gcontract.gcontractamount");
        sic.add("entry_gcontract.gcontractcurrency");
        sic.add("entry_gcontract.gexchrate");
        sic.add("entry_gcontract.gcomment");
        sic.add("entry_gcontract.gsrcbillid");
        sic.add("entry_gcontract.gsrcbilltype");
        sic.add("entry_gcontract.gcreditortype");
        sic.add("entry_gcontract.gcreditor");
        sic.add("entry_gcontract.gcreditortext");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject contractDO : dataEntities) {
            if (EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("back")))) {
                BusinessHelper.clearConfirmInfoForUnAudit((DynamicObject)contractDO);
            } else {
                BusinessHelper.clearConfirmInfoForBack((DynamicObject)contractDO);
            }
            contractDO.set("contractstatus", (Object)LoanContractStatusEnum.REGISTER.getValue());
            DynamicObject bizBill = contractDO;
            if (CfmContractBillHelper.mayUseCreditLimit((DynamicObject)contractDO) && !"fl_leasecontractbill_init".equals(bizBill.getDynamicObjectType().getName())) {
                String fields = contractDO.getDataEntityType().getProperties().parallelStream().map(o -> o.getName()).collect(Collectors.joining(","));
                if (this.getOperationVariable().containsKey("back")) {
                    String entityName = "cfm_loancontractbill".equals(bizBill.getDataEntityType().getName()) ? "cim_invest_contract" : "cfm_loancontractbill";
                    bizBill = TmcDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)entityName, (String)fields);
                }
                CreditLimitHelper.creditBizUnSubmit((DynamicObject)bizBill);
            }
            String creditorType = contractDO.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                contractDO.set("settlestatus", (Object)SettleCenterStatusEnum.ADDNEW.getValue());
            }
            this.resetSyncDrawContractGuaUse(contractDO);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmContractBillHelper.setLoanApplyBillConfirmStatus((DynamicObject[])dataEntities, (boolean)false);
    }

    private void resetSyncDrawContractGuaUse(DynamicObject loanContract) {
        HashMap<Long, List<Object>> loanCreditLimitMap = new HashMap<Long, List<Object>>(8);
        if (LoanTypeEnum.isBanksLoan((String)loanContract.getString("loantype"))) {
            DynamicObjectCollection bankSynEntry = loanContract.getDynamicObjectCollection("banksyndicate_entry");
            for (DynamicObject bankSynDo : bankSynEntry) {
                DynamicObject creditLimitDo = bankSynDo.getDynamicObject("e_creditlimit");
                DynamicObject bankDo = bankSynDo.getDynamicObject("e_bank");
                if (EmptyUtil.isEmpty((DynamicObject)creditLimitDo) || EmptyUtil.isEmpty((DynamicObject)bankDo)) continue;
                ArrayList loanListTemp = (ArrayList)loanCreditLimitMap.get(creditLimitDo.getLong("id"));
                if (loanListTemp == null) {
                    loanListTemp = new ArrayList(bankSynEntry.size());
                }
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("gcreditortype", bankSynDo.getString("e_bankrole"));
                map.put("gcreditor", bankDo.getLong("id"));
                map.put("gcreditortext", bankDo.getString("name"));
                loanListTemp.add(map);
                loanCreditLimitMap.put(creditLimitDo.getLong("id"), loanListTemp);
            }
        } else {
            DynamicObject loanContractCreditLimit = loanContract.getDynamicObject(CfmEntityConst.isLeaseContractBill((String)loanContract.getDataEntityType().getName()) ? "creditlimit" : "synccreditlimit");
            if (EmptyUtil.isNoEmpty((DynamicObject)loanContractCreditLimit)) {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("gcreditortype", loanContract.getString("creditortype"));
                map.put("gcreditor", loanContract.getLong("creditor"));
                map.put("gcreditortext", loanContract.getString("textcreditor"));
                loanCreditLimitMap.put(loanContractCreditLimit.getLong("id"), Collections.singletonList(map));
            }
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", loanContract.getPkValue());
        DynamicObjectCollection gcs = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (!loanCreditLimitMap.isEmpty()) {
            DynamicObjectCollection creditGcs = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter("gsrcbillid", "in", loanCreditLimitMap.keySet()).toArray());
            for (DynamicObject creditGc : creditGcs) {
                Long gContractId = creditGc.getLong("gcontract");
                for (Map map : (List)loanCreditLimitMap.get(creditGc.getLong("gsrcbillid"))) {
                    String creditorType = (String)map.get("gcreditortype");
                    Long creditor = (Long)map.get("gcreditor");
                    if (gcs.stream().filter(e -> gContractId.equals(e.getLong("gcontract")) && (CfmEntityConst.isLeaseContractBill((String)loanContract.getDataEntityType().getName()) || EmptyUtil.isNoEmpty((String)creditorType) && creditorType.equals(e.getString("gcreditortype")) && creditor != null && creditor.equals(e.getLong("gcreditor")))).count() > 0L) continue;
                    creditGc.set("gcreditortype", (Object)creditorType);
                    creditGc.set("gcreditor", (Object)creditor);
                    creditGc.set("gcreditortext", map.get("gcreditortext"));
                    gcs.add((Object)creditGc);
                }
            }
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
            return;
        }
        TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject gc : gcs) {
            if (BigDecimal.ZERO.compareTo(gc.getBigDecimal("gratio")) == 0) continue;
            String creditorType = gc.getString("gcreditortype");
            Long creditor = gc.getLong("gcreditor");
            ArrayList<DynamicObject> gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor);
            if (gcTemp == null) {
                gcTemp = new ArrayList<DynamicObject>(gcs.size());
            }
            gcTemp.add(gc);
            sumGcMap.put(creditorType + creditor, gcTemp);
        }
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)loanContract.getDataEntityType().getName(), (DynamicObject)loanContract);
        DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)loanContract.getLong("id"), (String)loanContract.getDataEntityType().getName());
        DynamicObjectCollection guaUseCollection = loanContract.getDynamicObjectCollection("entry_gcontract");
        guaUseCollection.clear();
        BigDecimal bizAmount = loanContract.getBigDecimal("amount");
        DynamicObject currency = loanContract.getDynamicObject("currency");
        for (Map.Entry entry : sumGcMap.entrySet()) {
            List gcsList = (List)entry.getValue();
            if (EmptyUtil.isEmpty((Collection)gcsList)) continue;
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (int i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject gc = (DynamicObject)gcsList.get(i);
                bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
                BigDecimal gRatio = gc.getBigDecimal("gratio");
                if (i == gcsList.size() - 1 && Constants.ONE_HUNDRED.compareTo(sumRatio) == 0) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    gRatio = EmptyUtil.isNoEmpty((DynamicObject)creditUseBill) ? gRatio.multiply(creditUseBill.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED) : gRatio;
                    gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                DynamicObject guaUseObject = guaUseCollection.addNew();
                LoanContractBillUnAuditService.addGuaranteeUseObject(gc, guaUseObject, loanContract, gAmount, gRatio);
            }
        }
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])new DynamicObject[]{loanContract}, (String[])new String[]{LoanTypeEnum.isBankLoan((String)loanContract.getString("loantype")) || LoanTypeEnum.isBanksLoan((String)loanContract.getString("loantype")) ? "cfm_loancontract_bl_l" : loanContract.getDataEntityType().getName()});
    }

    private static void addGuaranteeUseObject(DynamicObject guaranteeUseBill, DynamicObject guaUseDynamicObject, DynamicObject loanContract, BigDecimal gAmount, BigDecimal gRatio) {
        DynamicObject currency = loanContract.getDynamicObject("currency");
        DynamicObject guaRaContract = TmcDataServiceHelper.loadSingleFromCache((String)"gm_guaranteecontract_f7", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)guaranteeUseBill.getLong("gcontract"))});
        guaUseDynamicObject.set("gcontract", (Object)guaRaContract);
        guaUseDynamicObject.set("gamount", (Object)gAmount);
        guaUseDynamicObject.set("gratio", (Object)gRatio);
        guaUseDynamicObject.set("gcontractamount", (Object)guaranteeUseBill.getBigDecimal("gcontract.amount"));
        guaUseDynamicObject.set("gcontractcurrency", (Object)currency);
        guaUseDynamicObject.set("gexchrate", (Object)guaranteeUseBill.getBigDecimal("gexchrate"));
        guaUseDynamicObject.set("gcomment", (Object)guaranteeUseBill.getString("gcomment"));
        guaUseDynamicObject.set("gsrcbillid", (Object)loanContract.getLong("id"));
        guaUseDynamicObject.set("gsrcbilltype", (Object)loanContract.getDataEntityType().getName());
        if (!CfmEntityConst.isLeaseContractBill((String)loanContract.getDataEntityType().getName())) {
            guaUseDynamicObject.set("gcreditortype", (Object)guaranteeUseBill.getString("gcreditortype"));
            guaUseDynamicObject.set("gcreditor", (Object)guaranteeUseBill.getLong("gcreditor"));
            guaUseDynamicObject.set("gcreditortext", (Object)guaranteeUseBill.getString("gcreditortext"));
        }
    }
}

