/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractTradeSaveOrSubService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(LoanContractTradeSaveOrSubService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradefin_entry");
        sic.add("tradefin_entry.e_tf_relationtype");
        sic.add("tradefin_entry.e_tf_relatebillno");
        sic.add("tradefin_entry.e_tf_relatebillid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject contractDO : dataEntities) {
            this.dealTradeLoanTapInfo(contractDO);
        }
    }

    private void dealTradeLoanTapInfo(DynamicObject contractDO) {
        DynamicObject contractOldDB = null;
        try {
            contractOldDB = TmcDataServiceHelper.loadSingle((Object)contractDO.getPkValue(), (String)contractDO.getDynamicObjectType().getName());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        HashSet<Long> arrivalOldIdList = new HashSet<Long>(16);
        HashSet<Long> presentOldIdList = new HashSet<Long>(16);
        if (EmptyUtil.isNoEmpty((DynamicObject)contractOldDB)) {
            DynamicObjectCollection tradeOldDBEntrys = contractOldDB.getDynamicObjectCollection("tradefin_entry");
            for (DynamicObject tradeOldDBEntry : tradeOldDBEntrys) {
                String lcProductType = tradeOldDBEntry.getString("e_tf_relationtype");
                Long relateBillId = tradeOldDBEntry.getLong("e_tf_relatebillid");
                if (RelationTypeEnum.IL.getValue().equals(lcProductType) && EmptyUtil.isNoEmpty((Long)relateBillId)) {
                    arrivalOldIdList.add(relateBillId);
                }
                if (!RelationTypeEnum.EL.getValue().equals(lcProductType) || !EmptyUtil.isNoEmpty((Long)relateBillId)) continue;
                presentOldIdList.add(relateBillId);
            }
        }
        DynamicObjectCollection tradeEntrys = contractDO.getDynamicObjectCollection("tradefin_entry");
        HashSet<Long> arrivalIdList = new HashSet<Long>(16);
        HashSet<Long> presentIdList = new HashSet<Long>(16);
        for (DynamicObject tradeEntry : tradeEntrys) {
            String lcProductType = tradeEntry.getString("e_tf_relationtype");
            Long relateBillId = tradeEntry.getLong("e_tf_relatebillid");
            if (RelationTypeEnum.IL.getValue().equals(lcProductType) && EmptyUtil.isNoEmpty((Long)relateBillId)) {
                arrivalIdList.add(relateBillId);
            }
            if (!RelationTypeEnum.EL.getValue().equals(lcProductType) || !EmptyUtil.isNoEmpty((Long)relateBillId)) continue;
            presentIdList.add(relateBillId);
        }
        HashSet<Long> arrivalDelResult = new HashSet<Long>(arrivalOldIdList);
        arrivalDelResult.removeAll(arrivalIdList);
        HashSet<Long> presentDelResult = new HashSet<Long>(presentOldIdList);
        presentDelResult.removeAll(presentIdList);
        this.updateLcBillval(arrivalDelResult, RelationTypeEnum.IL.getEntiy(), "0");
        this.updateLcBillval(presentDelResult, RelationTypeEnum.EL.getEntiy(), "0");
        HashSet<Long> arrivalAddResult = new HashSet<Long>(arrivalIdList);
        arrivalAddResult.removeAll(arrivalOldIdList);
        HashSet<Long> presentAddResult = new HashSet<Long>(presentIdList);
        presentAddResult.removeAll(presentOldIdList);
        this.updateLcBillval(arrivalAddResult, RelationTypeEnum.IL.getEntiy(), "1");
        this.updateLcBillval(presentAddResult, RelationTypeEnum.EL.getEntiy(), "1");
    }

    private void updateLcBillval(Set<Long> lcIdList, String entity, String val) {
        if (!lcIdList.isEmpty()) {
            DynamicObject[] lcBills;
            for (DynamicObject lcBill : lcBills = TmcDataServiceHelper.load((String)entity, (String)"id,islinkcfm", (QFilter[])new QFilter("id", "in", lcIdList).toArray())) {
                lcBill.set("islinkcfm", (Object)val);
            }
            SaveServiceHelper.save((DynamicObject[])lcBills);
        }
    }
}

