/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class PreInstBillCorrectService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        Map dataMap;
        String confirmType = (String)this.getOperationVariable().get("confirmtype");
        String dataStr = (String)this.getOperationVariable().get("param_preintbillids");
        Map map = dataMap = EmptyUtil.isNoEmpty((String)dataStr) ? (Map)JSON.parseObject((String)dataStr, Map.class) : null;
        if (EmptyUtil.isEmpty((String)confirmType) || CollectionUtils.isEmpty((Map)dataMap)) {
            return;
        }
        Object[] ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName());
        dataEntities = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)dataEntityType);
        if (PreIntOperateTypeEnum.isSupInt((String)confirmType)) {
            this.doSupInt(dataEntities, dataMap);
        } else if (PreIntOperateTypeEnum.isWriteOffInt((String)confirmType)) {
            this.doWriteOff(dataEntities, dataMap);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void doSupInt(DynamicObject[] preIntBills, Map dataMap) {
        ArrayList<DynamicObject> newPreIntBills = new ArrayList<DynamicObject>(preIntBills.length);
        for (DynamicObject preIntBill : preIntBills) {
            BigDecimal supIntAmt = (BigDecimal)dataMap.get(preIntBill.getPkValue());
            if (EmptyUtil.isEmpty((BigDecimal)supIntAmt)) continue;
            BigDecimal noWriteOffAmt = preIntBill.getBigDecimal("nowriteoffamt");
            preIntBill.set("nowriteoffamt", (Object)noWriteOffAmt.add(supIntAmt));
            DynamicObject newPreInt = this.clonePreIntBill(preIntBill);
            newPreInt.set("supintamt", (Object)supIntAmt);
            newPreInt.set("operatetype", (Object)PreIntOperateTypeEnum.SUPINT.getValue());
            newPreIntBills.add(newPreInt);
        }
        this.batchSave(newPreIntBills);
    }

    private void doWriteOff(DynamicObject[] preIntBills, Map dataMap) {
        ArrayList<DynamicObject> newPreIntBills = new ArrayList<DynamicObject>(preIntBills.length);
        for (DynamicObject preIntBill : preIntBills) {
            BigDecimal writeOffAmt = (BigDecimal)dataMap.get(preIntBill.getPkValue());
            if (EmptyUtil.isEmpty((BigDecimal)writeOffAmt)) continue;
            BigDecimal noWriteOffAmt = preIntBill.getBigDecimal("nowriteoffamt");
            BigDecimal newNoWriteOffAmt = noWriteOffAmt.subtract(writeOffAmt);
            preIntBill.set("nowriteoffamt", (Object)newNoWriteOffAmt);
            String writeOffStatus = newNoWriteOffAmt.compareTo(BigDecimal.ZERO) > 0 ? WriteOffStatusEnum.PART_WRITEOFF.getValue() : WriteOffStatusEnum.WRITEOFF.getValue();
            preIntBill.set("writeoffstatus", (Object)writeOffStatus);
            DynamicObject newPreInt = this.clonePreIntBill(preIntBill);
            newPreInt.set("writeoffamt", (Object)writeOffAmt);
            newPreInt.set("operatetype", (Object)PreIntOperateTypeEnum.WRITEOFFINT.getValue());
            newPreIntBills.add(newPreInt);
        }
        this.batchSave(newPreIntBills);
    }

    private DynamicObject clonePreIntBill(DynamicObject preIntBill) {
        DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)preIntBill);
        newPreInt.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        newPreInt.set("billno", null);
        newPreInt.set("createtime", (Object)new Date());
        newPreInt.set("creator", (Object)RequestContext.get().getCurrUserId());
        newPreInt.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
        newPreInt.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        newPreInt.set("writeoffpreintbillid", preIntBill.getPkValue());
        return newPreInt;
    }

    private void batchSave(List<DynamicObject> newPreIntBills) {
        if (EmptyUtil.isEmpty(newPreIntBills)) {
            return;
        }
        this.removeBatchRelation(newPreIntBills);
        String entityName = newPreIntBills.get(0).getDynamicObjectType().getName();
        TmcOperateServiceHelper.execOperate((String)"save", (String)entityName, (DynamicObject[])newPreIntBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        List srcTarIds = newPreIntBills.stream().map(v -> Pair.of((Object)v.getLong("writeoffpreintbillid"), (Object)v.getLong("id"))).collect(Collectors.toList());
        TmcBotpHelper.batchSaveRelation((String)entityName, (String)entityName, srcTarIds);
    }

    private void removeBatchRelation(List<DynamicObject> newPreIntBills) {
        long batchBillTableId = EntityMetadataCache.loadMainTableDefine((String)"cfm_intbill_batch_pre").getTableId();
        for (DynamicObject newPreIntBill : newPreIntBills) {
            DynamicObjectCollection entry = newPreIntBill.getDynamicObjectCollection("billhead_lk");
            entry.removeIf(v -> v.getLong("billhead_lk_stableid") == batchBillTableId);
        }
    }
}

