/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class PreIntBillBathUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("interesttype");
        selector.add("entry");
        selector.add("intbillid");
        selector.add("intdetailnum");
        selector.add("inneracct");
        selector.add("operateType");
        selector.add("loannum");
        selector.add("sourceentryid");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("status");
        selector.add("loantype");
        selector.add("datasource");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchPreIntBill : dataEntities) {
            DynamicObjectCollection entry = batchPreIntBill.getDynamicObjectCollection("entry");
            String interestType = batchPreIntBill.getString("interesttype");
            if (!StringUtils.equals((CharSequence)interestType, (CharSequence)"preint")) continue;
            this.doLoanPreInt(batchPreIntBill);
            entry.forEach(row -> {
                row.set("intbillid", null);
                row.set("intdetailnum", null);
                row.set("status", (Object)"");
            });
        }
    }

    private void doLoanPreInt(DynamicObject batchPreIntBill) {
        DynamicObjectCollection entrys = batchPreIntBill.getDynamicObjectCollection("entry");
        List preInstIds = entrys.stream().map(v -> v.getLong("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(preInstIds)) {
            String loanType = batchPreIntBill.getString("loantype");
            String datasource = batchPreIntBill.getString("datasource");
            Pair botpPairObj = BatchIntBillHelper.getPreIntBotpPair((String)loanType, (String)datasource);
            String entityName = (String)botpPairObj.getRight();
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)EntityMetadataCache.getDataEntityType((String)entityName).getName(), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", preInstIds)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)preInterestBills)) {
                return;
            }
            Object[] auditBillIds = preInterestBills.stream().filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())).map(d -> d.get("id")).toArray();
            Object[] submitBillIds = preInterestBills.stream().filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())).map(d -> d.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])auditBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])auditBillIds, (OperateOption)OperateOption.create());
            }
            if (EmptyUtil.isNoEmpty((Object[])submitBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitBillIds, (OperateOption)OperateOption.create());
            }
            Object[] preIntBillIds = preInterestBills.stream().map(d -> d.get("id")).toArray();
            Map opMap = this.getOperationVariable();
            String appId = Optional.ofNullable(opMap.get("appnumber")).orElseGet(() -> (String)opMap.get("currbizappid"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("appid", appId);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])preIntBillIds, (OperateOption)option);
        }
    }
}

