/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class PreInterestBillDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billstatus");
        ias.add("prestenddate");
        ias.add("prestartdate");
        ias.add("operatetype");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String currBillAppId = Optional.ofNullable(this.getOperationVariable().get("appid")).orElse("");
        for (DynamicObject preInstBill : dataEntities) {
            if (LoanBillHelper.isCorrectPreIntBill((DynamicObject)preInstBill)) continue;
            LoanBillHelper.autoUnRedWriteOff((DynamicObject)preInstBill, (String)currBillAppId);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Set loanBillIds = Arrays.stream(dataEntities).filter(d -> !LoanBillHelper.isCorrectPreIntBill((DynamicObject)d)).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.PREINTEREST);
    }
}

