/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.business.opservice.preinterestbill.PreInstCalService;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInterestBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billstatus");
        ias.add("prestartdate");
        ias.add("prestenddate");
        ias.add("entrys");
        ias.add("nowriteoffamt");
        ias.add("instenddate");
        ias.add("creditorg");
        ias.add("confirmstatus");
        ias.add("confirmer");
        ias.add("confirmtime");
        ias.add("loanbillno");
        ias.add("batchnoid");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (this.getOperationVariable().containsKey("redwriteoffop")) {
            return;
        }
        for (DynamicObject preInstBill : dataEntities) {
            DynamicObjectCollection instEntrys = preInstBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)instEntrys)) {
                String entityName = preInstBill.getDataEntityType().getName();
                if (BatchIntBillHelper.isDepostPreInt((String)entityName)) {
                    TmcOperateServiceHelper.execOperate((String)"depositcalinterest", (String)entityName, (DynamicObject[])new DynamicObject[]{preInstBill}, (OperateOption)OperateOption.create());
                } else {
                    new PreInstCalService().process(new DynamicObject[]{preInstBill});
                }
            }
            if (EmptyUtil.isEmpty((BigDecimal)preInstBill.getBigDecimal("nowriteoffamt")) && (BillStatusEnum.SAVE.getValue().equals(preInstBill.getString("billstatus")) || BillStatusEnum.SUBMIT.getValue().equals(preInstBill.getString("billstatus")))) {
                preInstBill.set("nowriteoffamt", (Object)preInstBill.getBigDecimal("actpreinstamt"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)instEntrys)) {
                preInstBill.set("bizdate", (Object)((DynamicObject)instEntrys.get(instEntrys.size() - 1)).getDate("instenddate"));
            }
            this.setConfirmStatus(preInstBill);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Map opMap = this.getOperationVariable();
        if (opMap.containsKey("redwriteoffop")) {
            return;
        }
        String currBillAppId = Optional.ofNullable(opMap.get("appid")).orElse("");
        for (DynamicObject preInterestEntity : dataEntities) {
            if (TmcAppEnum.CIM.getValue().equals(currBillAppId) || "ifm_depositpreint".equals(preInterestEntity.getDynamicObjectType().getName())) continue;
            LoanBillHelper.autoRedWriteOff((DynamicObject)preInterestEntity);
            LoanWriteBackHelper.writeBack((Long)preInterestEntity.getLong("sourcebillid"), (LoanWBTypeEnum)LoanWBTypeEnum.PREINTEREST);
        }
    }

    private void setConfirmStatus(DynamicObject preInstBill) {
        preInstBill.set("confirmstatus", (Object)ConfirmStatusEnum.REGISTRYING.getValue());
        preInstBill.set("confirmer", null);
        preInstBill.set("confirmtime", null);
    }
}

