/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInterestBillUnCorrectService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("writeoffpreintbillid");
        selector.add("operatetype");
        selector.add("supintamt");
        selector.add("writeoffamt");
        selector.add("contractbillno");
        selector.add("sourcebillid");
        selector.add("billstatus");
        selector.add("prestenddate");
        selector.add("prestartdate");
        selector.add("loanbillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.updateCorrectedPreInstBills(dataEntities);
        this.deleteCorrectPreInstBills(dataEntities);
    }

    private void updateCorrectedPreInstBills(DynamicObject[] dataEntities) {
        Object[] ids = Arrays.stream(dataEntities).map(v -> v.get("writeoffpreintbillid")).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        Object[] correctPreInstBills = TmcDataServiceHelper.load((String)entityName, (String)"id,actpreinstamt,writeoffamt,writeoffstatus,nowriteoffamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Map dataMap = Arrays.stream(correctPreInstBills).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        ArrayList<Object> supIntIds = new ArrayList<Object>();
        for (DynamicObject preIntBill : dataEntities) {
            BigDecimal noWriteOffAmt;
            DynamicObject correctPreInstBill = (DynamicObject)dataMap.get(preIntBill.get("writeoffpreintbillid"));
            if (EmptyUtil.isEmpty((DynamicObject)correctPreInstBill)) continue;
            String operateType = preIntBill.getString("operatetype");
            BigDecimal oldNoWriteOffAmt = correctPreInstBill.getBigDecimal("nowriteoffamt");
            if (PreIntOperateTypeEnum.isSupInt((String)operateType)) {
                noWriteOffAmt = oldNoWriteOffAmt.subtract(preIntBill.getBigDecimal("supintamt"));
                supIntIds.add(preIntBill.getPkValue());
            } else {
                noWriteOffAmt = oldNoWriteOffAmt.add(preIntBill.getBigDecimal("writeoffamt"));
            }
            correctPreInstBill.set("nowriteoffamt", (Object)noWriteOffAmt);
            this.setWriteOffStatus(correctPreInstBill, supIntIds);
        }
        if (EmptyUtil.isNoEmpty((Object[])correctPreInstBills)) {
            SaveServiceHelper.update((DynamicObject[])correctPreInstBills);
        }
    }

    private void deleteCorrectPreInstBills(DynamicObject[] dataEntities) {
        Arrays.stream(dataEntities).forEach(v -> v.set("billstatus", (Object)BillStatusEnum.SAVE.getValue()));
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
    }

    private void setWriteOffStatus(DynamicObject correctPreInstBill, List<Object> supIntIds) {
        BigDecimal noWriteOffAmt = correctPreInstBill.getBigDecimal("nowriteoffamt");
        BigDecimal actPreInstAmt = correctPreInstBill.getBigDecimal("actpreinstamt");
        String writeOffStatus = noWriteOffAmt.compareTo(BigDecimal.ZERO) <= 0 ? WriteOffStatusEnum.WRITEOFF.getValue() : (noWriteOffAmt.compareTo(actPreInstAmt) < 0 ? WriteOffStatusEnum.PART_WRITEOFF.getValue() : (noWriteOffAmt.compareTo(actPreInstAmt = this.getActPreInstAmt(correctPreInstBill, supIntIds)) < 0 ? WriteOffStatusEnum.PART_WRITEOFF.getValue() : WriteOffStatusEnum.NO_WRITEOFF.getValue()));
        correctPreInstBill.set("writeoffstatus", (Object)writeOffStatus);
    }

    private BigDecimal getActPreInstAmt(DynamicObject correctPreInstBill, List<Object> supIntIds) {
        BigDecimal actPreInstAmt = correctPreInstBill.getBigDecimal("actpreinstamt");
        Object[] supIntBills = LoanBillHelper.getCorrectBills((Object)correctPreInstBill.getPkValue(), (String)PreIntOperateTypeEnum.SUPINT.getValue());
        if (EmptyUtil.isNoEmpty((Object[])supIntBills)) {
            BigDecimal totalSupInt = Arrays.stream(supIntBills).filter(v -> !supIntIds.contains(v.getPkValue())).map(v -> v.getBigDecimal("supintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            actPreInstAmt = actPreInstAmt.add(totalSupInt);
        }
        return actPreInstAmt;
    }
}

