/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.rateadjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustWriteBackHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("billstatus");
        sic.add("loancontractbill");
        sic.add("adjustele");
        sic.add("refrate");
        sic.add("rateadjustkey");
        sic.add("rateadjustval");
        sic.add("ratesign");
        sic.add("interestrate");
        sic.add("ratefloatpoint");
        sic.add("afterrefrate");
        sic.add("afterrateadjustkey");
        sic.add("afterrateadjustval");
        sic.add("afterratesign");
        sic.add("afterinterestrate");
        sic.add("afterratefloatpoint");
        sic.add("adjusteffectdate");
        sic.add("datasource");
        sic.add("isadjusttofloat");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("issofrrate");
        sic.add("rateresetdays");
        sic.add("settleintmode");
        sic.add("interestsettledplan");
        sic.add("entry");
        sic.add("entry.lloanrate");
        sic.add("entry.lratesign");
        sic.add("entry.lratefloatpoint");
        sic.add("entry.afterlloanrate");
        sic.add("entry.afterlratesign");
        sic.add("entry.afterlratefloatpoint");
        sic.add("entry.ldrawbill");
        sic.add("entry.lisadjust");
        sic.add("entry.lsettleintmode");
        sic.add("entry.linterestsettledplan");
        sic.add("entry.lrateadjustdate");
        sic.add("entry.lissofrrate");
        sic.add("entry.loanrateadjuststyle");
        sic.add("entry.lrefrate");
        sic.add("entry.afterlrefrate");
        sic.add("entry.lrateadjustkey");
        sic.add("entry.lrateadjustval");
        sic.add("entry.afterlrateadjustkey");
        sic.add("entry.afterlrateadjustval");
        sic.add("entry.ladjusteffectdate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmRateAdjustWriteBackHelper.writeback((DynamicObject[])dataEntities, (Map)this.getOperationVariable());
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List loanIds = Arrays.stream(dataEntities).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(o -> o.getBoolean("lisadjust")).map(o -> o.getDynamicObject("ldrawbill").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(loanIds)) {
            LoanWriteBackHelper.writeBack(loanIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
        }
    }
}

