/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.rateadjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustWriteBackHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBillSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        if (this.isFromIsc()) {
            this.handleOpFromIsc(dataEntities);
        }
    }

    private void handleOpFromIsc(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> auditBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            if (!BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            auditBills.add(bill);
        }
        if (auditBills.isEmpty()) {
            return;
        }
        DynamicObject[] billArrs = auditBills.toArray(new DynamicObject[0]);
        CfmRateAdjustWriteBackHelper.writeback((DynamicObject[])billArrs, (Map)this.getOperationVariable());
        List loanIds = Arrays.stream(billArrs).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(o -> o.getBoolean("lisadjust")).map(o -> o.getDynamicObject("ldrawbill").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(loanIds)) {
            LoanWriteBackHelper.writeBack(loanIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
        }
    }

    private boolean isFromIsc() {
        return "Y".equals(this.operationVariable.get("op_from_isc"));
    }
}

