/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repayapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sdk.tmc.cfm.extpoint.repayapply.IRepayApplyBillSecondDevFields;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepayApplyBillPush2RepayService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RepayApplyBillPush2RepayService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_loanbill");
        sic.add("isratio");
        sic.add("isrelcash");
        sic.add("amount");
        sic.add("instamt");
        sic.add("totalamt");
        sic.add("e_repayamount");
        sic.add("e_ispayinst");
        sic.add("e_preintamt");
        sic.add("e_calintamt");
        sic.add("intdetail");
        sic.add("intdetail_tag");
        sic.add("e_combineinst");
        sic.add("loancontractbill");
        sic.add("prerepaydate");
        sic.add("businessstatus");
        sic.add("payeetype");
        sic.add("payee");
        sic.add("payeetext");
        sic.add("payeeaccttext");
        sic.add("payeebank");
        sic.add("accountbank");
        sic.add("isbuyback");
        sic.add("creator");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject repayApplyBill : dataEntities) {
            this.doPush2RepayBill(repayApplyBill);
        }
    }

    private void doPush2RepayBill(DynamicObject repayApplyBill) {
        DynamicObject[] repayBills;
        repayApplyBill.set("businessstatus", (Object)ApplyBusinessStatusEnum.HANDING.getValue());
        Date prePayDate = repayApplyBill.getDate("prerepaydate");
        boolean isRatio = repayApplyBill.getBoolean("isratio");
        boolean isRelCash = repayApplyBill.getBoolean("isrelcash");
        BigDecimal repayAmt = repayApplyBill.getBigDecimal("amount");
        BigDecimal repayAndInstAmt = repayApplyBill.getBigDecimal("totalamt");
        DynamicObjectCollection loans = repayApplyBill.getDynamicObjectCollection("loans");
        Map loanIdPropMap = loans.stream().collect(Collectors.toMap(o -> o.getDynamicObject("e_loanbill").getLong("id"), Function.identity()));
        Object[] loanBillIds = loans.stream().map(o -> o.getDynamicObject("e_loanbill").getLong("id")).toArray();
        String sourceBill = "cfm_loanbill";
        String targetBill = "cfm_repaymentbill";
        String entity = repayApplyBill.getDynamicObjectType().getName();
        if ("fl_rentpay_apply".equals(entity)) {
            sourceBill = "fl_receiptbill";
            targetBill = "fl_rentpaybill";
        } else if ("cfm_repayapplybill_bond".equals(entity)) {
            sourceBill = "cfm_loanbill_bond";
            targetBill = "cfm_repaymentbill";
        }
        for (DynamicObject repayBill : repayBills = TmcBotpHelper.batchPush((Object[])loanBillIds, (String)sourceBill, (String)targetBill)) {
            repayBill.set("repayapplyf7", (Object)repayApplyBill);
            repayBill.set("bizdate", (Object)prePayDate);
            repayBill.set("isratio", (Object)isRatio);
            repayBill.set("isrelcash", (Object)isRelCash);
            repayBill.set("amount", (Object)repayAmt);
            repayBill.set("totalamt", (Object)repayAndInstAmt);
            repayBill.set("creator", (Object)repayApplyBill.getDynamicObject("creator"));
            if ("fl_rentpay_apply".equals(entity)) {
                repayBill.set("instamt", (Object)repayApplyBill.getBigDecimal("instamt"));
            } else {
                repayBill.set("accountbank", (Object)repayApplyBill.getDynamicObject("accountbank"));
            }
            if ("cfm_repayapplybill_bond".equals(entity)) {
                repayBill.set("payeetype", (Object)repayApplyBill.getString("payeetype"));
                repayBill.set("payee", (Object)repayApplyBill.getDynamicObject("payee"));
                repayBill.set("payeetext", (Object)repayApplyBill.getString("payeetext"));
                repayBill.set("payeeaccttext", (Object)repayApplyBill.getString("payeeaccttext"));
                repayBill.set("payeebank", (Object)repayApplyBill.getDynamicObject("payeebank"));
                repayBill.set("isbuyback", (Object)repayApplyBill.getBoolean("isbuyback"));
            }
            DynamicObjectCollection repayLoans = repayBill.getDynamicObjectCollection("loans");
            for (DynamicObject repayLoanInfo : repayLoans) {
                DynamicObject repayApplyEntry = (DynamicObject)loanIdPropMap.get(repayLoanInfo.getDynamicObject("e_loanbill").getLong("id"));
                repayLoanInfo.set("e_repayamount", (Object)repayApplyEntry.getBigDecimal("e_repayamount"));
                this.setConvertRepayAmt(repayLoanInfo, repayApplyEntry);
                repayLoanInfo.set("e_ispayinst", (Object)repayApplyEntry.getBoolean("e_ispayinst"));
                repayLoanInfo.set("e_combineinst", (Object)repayApplyEntry.getBoolean("e_combineinst"));
                repayLoanInfo.set("e_actintamt", (Object)repayApplyEntry.getBigDecimal("e_preintamt"));
                repayLoanInfo.set("e_calintamt", (Object)repayApplyEntry.getBigDecimal("e_calintamt"));
                repayLoanInfo.set("intdetail", (Object)repayApplyEntry.getString("intdetail"));
                repayLoanInfo.set("intdetail_tag", (Object)repayApplyEntry.getString("intdetail_tag"));
            }
            RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repayBill, (String)"e_repayamount", (String)"s_repayamount");
            RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repayBill, (String)"e_actintamt", (String)"s_repayinst");
        }
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{repayApplyBill});
        OperateOption option = OperateOption.create();
        this.dealRepayApplySecondDev(repayApplyBill, option);
        try {
            option.setVariableValue("RepayApplyBillPush2Repay", "true");
            TmcOperateServiceHelper.execOperate((String)"save", (String)repayBills[0].getDataEntityType().getName(), (DynamicObject[])repayBills, (OperateOption)option);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8fd8\u6b3e\u5355\u4e0b\u63a8\u5931\u8d25:%s\u3002", (String)"RepayApplyBillPush2RepayService_1", (String)"tmc-cfm-business", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void setConvertRepayAmt(DynamicObject repayLoanInfo, DynamicObject repayApplyEntry) {
        BigDecimal repayAmount = repayApplyEntry.getBigDecimal("e_repayamount");
        repayLoanInfo.set("e_convertrepayamt", (Object)repayApplyEntry.getBigDecimal("e_repayamount"));
        DynamicObject loanBillF7 = repayApplyEntry.getDynamicObject("e_loanbill");
        BigDecimal convertRate = loanBillF7.getBigDecimal("convertrate");
        convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
        repayLoanInfo.set("e_convertactintamt", (Object)repayApplyEntry.getBigDecimal("e_preintamt").multiply(convertRate));
        repayLoanInfo.set("e_convertrepayamt", (Object)repayAmount.multiply(convertRate));
        if (repayAmount.compareTo(loanBillF7.getBigDecimal("notrepayamount")) == 0) {
            BigDecimal yetRepayAmt = RepaymentBillRepository.getRepayAmountByLoanBillId((Long)loanBillF7.getLong("id"));
            logger.info("\u6700\u540e\u4e00\u6b21\u8fd8\u6b3e\uff0c\u5df2\u8fd8\u91d1\u989d yetRepayAmt=" + yetRepayAmt);
            repayLoanInfo.set("e_convertrepayamt", (Object)loanBillF7.getBigDecimal("convertdrawamt").subtract(yetRepayAmt));
        }
    }

    private void dealRepayApplySecondDev(DynamicObject repayApplyBill, OperateOption option) {
        PluginProxy pluginProxy = PluginProxy.create(IRepayApplyBillSecondDevFields.class, (String)"kd.sdk.tmc.cfm.extpoint.repayapply.IRepayApplyBillSecondDevFields.repayApplyBillSecondDevFields");
        List result = pluginProxy.callReplace(proxy -> proxy.repayApplyBillSecondDevFields(repayApplyBill)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        logger.info(String.format("\u5904\u7406\u7ed3\u679c\u53c2\u6570\uff1a%s", result));
        if (EmptyUtil.isNoEmpty(result) && EmptyUtil.isNoEmpty(result.get(0))) {
            Map fields = (Map)result.get(0);
            option.setVariableValue("SecondDevFieldVal", JSON.toJSONString((Object)fields));
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        Object[] applyids = Arrays.stream(dataEntities).map(o -> o.getLong("id")).toArray();
        DeleteServiceHelper.delete((String)"cfm_repaymentbill", (QFilter[])new QFilter[]{new QFilter("repayapplyf7", "in", (Object)applyids)});
    }
}

