/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RepaymentBillAuditService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_ispayinst");
        sic.add("e_loanbill");
        sic.add("e_repayamount");
        sic.add("e_convertrepayamt");
        sic.add("repayapplyf7");
        sic.add("confirmstatus");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("creditorg");
        sic.add("org");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        sic.add("productfactory");
        sic.add("returnreason");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("currency");
        sic.add("loantype");
        sic.add("creditortype");
        sic.add("creditor");
        sic.add("settlestatus");
        sic.add("amount");
        sic.add("loantype");
        sic.add("bizdate");
        sic.add("auditdate");
        sic.add("auditor");
        sic.add("billno");
        sic.add("isbuyback");
        sic.add("slentryentity");
        sic.add("s_repayinst");
        sic.add("s_loanbillno");
        sic.add("s_bankrole");
        sic.add("s_repayamount");
        sic.add("s_bank");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DynamicObject> repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        this.fillHeadProps(repayBills);
        this.dealIntBills(repayBills);
        this.dealBondLimit(repayBills);
    }

    private boolean isAutoConfirm(DynamicObject repay) {
        return !CreditorTypeEnum.SETTLECENTER.getValue().equals(repay.getString("creditortype")) && BusinessHelper.isAutoConfirm((DynamicObject)repay);
    }

    private void fillHeadProps(List<DynamicObject> repayBills) {
        for (DynamicObject repay : repayBills) {
            repay.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            repay.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
            String creditorType = repay.getString("creditortype");
            if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) continue;
            String entityName = repay.getDataEntityType().getName();
            if ("cfm_repaymentbill".equals(entityName)) {
                repay.set("settlestatus", (Object)SettleCenterStatusEnum.SUBMIT.getValue());
                continue;
            }
            repay.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
        }
        List autoRepayBills = repayBills.stream().filter(this::isAutoConfirm).collect(Collectors.toList());
        if (!autoRepayBills.isEmpty()) {
            BusinessHelper.fillConfirmInfo(autoRepayBills);
            CfmBillCommonHelper.updateApplyBizStatus(autoRepayBills, (String)"repayapplyf7", (String)"cfm_repayapplybill", (String)ApplyBusinessStatusEnum.HANDED.getValue());
        }
    }

    private void dealBondLimit(List<DynamicObject> repayBills) {
        if (EmptyUtil.isEmpty(repayBills = repayBills.stream().filter(d -> LoanTypeEnum.isBond((String)d.getString("loantype"))).collect(Collectors.toList()))) {
            return;
        }
        ArrayList loanBillIds = new ArrayList(repayBills.size());
        for (DynamicObject dynamicObject : repayBills) {
            loanBillIds.addAll(dynamicObject.getDynamicObjectCollection("loans").stream().map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toList()));
        }
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id,occupybondlimit,billno,drawamount", (QFilter[])new QFilter[]{new QFilter("id", "in", loanBillIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanBills)) {
            return;
        }
        Map<Long, DynamicObject> map = loanBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (DynamicObject dynamicObject : repayBills) {
            for (DynamicObject loan : dynamicObject.getDynamicObjectCollection("loans")) {
                Long occupyBondLimitId;
                Long loanbillId = loan.getLong("e_loanbill.id");
                DynamicObject cfmLoanbillBond = map.get(loanbillId);
                if (cfmLoanbillBond == null || !EmptyUtil.isNoEmpty((Long)(occupyBondLimitId = Long.valueOf(cfmLoanbillBond.getLong("occupybondlimit"))))) continue;
                BondLimitHelper.changeLimitOnRepaymentAudit((DynamicObject)cfmLoanbillBond, (Object)occupyBondLimitId, (BigDecimal)loan.getBigDecimal("e_repayamount"));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        ArrayList<DynamicObject> autoRepayBills = new ArrayList<DynamicObject>(10);
        HashSet<Long> loanBillIds = new HashSet<Long>(16);
        for (DynamicObject repayBill : repayBills) {
            if (!BusinessHelper.isAutoConfirm((DynamicObject)repayBill)) continue;
            autoRepayBills.add(repayBill);
            for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
                loanBillIds.add(entry.getDynamicObject("e_loanbill").getLong("id"));
            }
        }
        Map operationVariable = this.getOperationVariable();
        boolean isWf = operationVariable.containsKey("WF") || operationVariable.containsKey("wf");
        logger.info("\u662f\u5426\u4f7f\u7528\u5de5\u4f5c\u6d41\u5ba1\u6838: {}, variable: {}", (Object)isWf, (Object)operationVariable);
        ArrayList loanBillIdList = new ArrayList(loanBillIds);
        LoanWriteBackHelper.writeBack(loanBillIdList, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
        List<DynamicObject> returnCreditRepayBills = autoRepayBills.stream().filter(this::isReturnCreditLimit).collect(Collectors.toList());
        RepayServiceHelper.returnCreditLimit(returnCreditRepayBills);
    }

    private boolean isReturnCreditLimit(DynamicObject repayBill) {
        String creditorType = repayBill.getString("creditortype");
        if (CreditorTypeEnum.isSettleCenter((String)creditorType)) {
            return false;
        }
        return !repayBill.containsProperty("isbuyback") || !repayBill.getBoolean("isbuyback");
    }

    private void dealIntBills(List<DynamicObject> repayBills) {
        List billIds = BusinessHelper.getBizBillIds(repayBills);
        DynamicObjectCollection interestBills = InterestBillRepository.queryByFilter((QFilter)new QFilter("repaymentid", "in", (Object)billIds), (String)"id,repaymentid,loanbillno,billno,billstatus");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestBills)) {
            return;
        }
        String repayEntityName = repayBills.get(0).getDynamicObjectType().getName();
        String interestEntity = CfmBillCommonHelper.getInterestEntity((String)repayEntityName);
        Map<Long, List<DynamicObject>> interestBillMap = interestBills.stream().collect(Collectors.groupingBy(d -> d.getLong("repaymentid")));
        for (DynamicObject repay : repayBills) {
            Object[] waiteAuditInts;
            Object loan2;
            List<DynamicObject> instBills = interestBillMap.get(repay.getLong("id"));
            if (EmptyUtil.isEmpty(instBills)) continue;
            HashMap<String, Boolean> loanBillMap = new HashMap<String, Boolean>();
            DynamicObjectCollection loans = repay.getDynamicObjectCollection("loans");
            for (Object loan2 : loans) {
                DynamicObject loanBill = loan2.getDynamicObject("e_loanbill");
                BigDecimal notRepayAmount = loanBill.getBigDecimal("notrepayamount");
                BigDecimal rePayAmount = loan2.getBigDecimal("e_repayamount");
                loanBillMap.put(loanBill.getString("number"), notRepayAmount.compareTo(rePayAmount) == 0);
            }
            HashMap<String, Boolean> intBillMap = new HashMap<String, Boolean>();
            loan2 = instBills.iterator();
            while (loan2.hasNext()) {
                DynamicObject instBill = (DynamicObject)loan2.next();
                Boolean isSettled = (Boolean)loanBillMap.get(instBill.getString("loanbillno"));
                intBillMap.put(instBill.getString("billno"), EmptyUtil.isEmpty((Object)isSettled) ? Boolean.FALSE : isSettled);
            }
            boolean repayAutoConfirm = BusinessHelper.isAutoConfirm((DynamicObject)repay);
            OperateOption option = OperateOption.create();
            option.setVariableValue("repayAutoConfirm", repayAutoConfirm ? "true" : "false");
            option.setVariableValue("settleinfo", SerializationUtils.toJsonString(intBillMap));
            option.setVariableValue("WF", "TRUE");
            Object[] saveStatusInts = instBills.stream().filter(v -> BillStatusEnum.isSave((String)v.getString("billstatus"))).map(d -> d.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])saveStatusInts)) {
                TmcOperateServiceHelper.execOperate((String)"submit", (String)interestEntity, (Object[])saveStatusInts, (OperateOption)option);
            }
            if (!EmptyUtil.isNoEmpty((Object[])(waiteAuditInts = instBills.stream().filter(v -> !BillStatusEnum.isAudit((String)v.getString("billstatus"))).map(d -> d.get("id")).toArray()))) continue;
            TmcOperateServiceHelper.execOperate((String)"audit", (String)interestEntity, (Object[])waiteAuditInts, (OperateOption)option);
        }
    }
}

