/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillBuyBackAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RepaymentBillBuyBackAuditService.class);
    private static final String LOAN_BILL_PROPS = String.join((CharSequence)",", "id", "investor_entry", String.join((CharSequence)".", "investor_entry", "e_buybackedamt"), String.join((CharSequence)".", "investor_entry", "e_investorname"), String.join((CharSequence)".", "investor_entry", "e_investamount"), String.join((CharSequence)".", "investor_entry", "e_avalinvestamt"));
    private static final String BOND_BILL_PROPS_QR = "id,billno,currency,notrepayamount,drawamount,investor_entry,investor_entry.e_creditlimit,investor_entry.e_investorid,investor_entry.e_investamount";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("buyback_entry");
        sic.add("loans");
        sic.add("bizdate");
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investortype"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investorname"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investorid"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investamount"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investentryid"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_avalinvestamt"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_buybackamt"));
        sic.add(String.join((CharSequence)".", "loans", "e_currency"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        for (DynamicObject repayBill : repayBills) {
            if (!repayBill.containsProperty("isbuyback") || !repayBill.getBoolean("isbuyback")) continue;
            RepaymentBillBuyBackAuditService.updateBondLoanBillInvestInfo(repayBill);
        }
    }

    private static void updateBondLoanBillInvestInfo(DynamicObject repayBill) {
        DynamicObject[] bondBills;
        Map<Long, DynamicObjectCollection> bondIdAndBbCols = RepaymentBillBuyBackAuditService.getLoanIdAndBuyBackCols(repayBill);
        if (EmptyUtil.isEmpty(bondIdAndBbCols)) {
            return;
        }
        for (DynamicObject bondBill : bondBills = TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)LOAN_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", bondIdAndBbCols.keySet())})) {
            DynamicObjectCollection buyBackCols = bondIdAndBbCols.get(bondBill.getLong("id"));
            Map<Long, DynamicObject> buyBackMap = buyBackCols.stream().collect(Collectors.toMap(k -> k.getLong("e_investentryid"), v -> v));
            DynamicObjectCollection investCols = bondBill.getDynamicObjectCollection("investor_entry");
            for (DynamicObject investCol : investCols) {
                DynamicObject buyBackCol = buyBackMap.get(investCol.getLong("id"));
                investCol.set("e_buybackedamt", (Object)investCol.getBigDecimal("e_buybackedamt").add(buyBackCol.getBigDecimal("e_buybackamt")));
                investCol.set("e_avalinvestamt", (Object)investCol.getBigDecimal("e_investamount").subtract(investCol.getBigDecimal("e_buybackedamt")));
                buyBackCol.set("e_avalinvestamt", (Object)investCol.getBigDecimal("e_avalinvestamt"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])bondBills);
    }

    private static Map<Long, DynamicObjectCollection> getLoanIdAndBuyBackCols(DynamicObject repayBill) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        HashMap<Long, DynamicObjectCollection> loanIdAndBbCols = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject loan : loans) {
            DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)loanBill)) continue;
            loanIdAndBbCols.put(loanBill.getLong("id"), loan.getDynamicObjectCollection("buyback_entry"));
        }
        return loanIdAndBbCols;
    }

    private static Map<Long, List<DynamicObject>> getBondIdAndInvestCols(DynamicObject repayBill) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        List BondIds = loans.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("e_loanbill"))).map(e -> e.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection loanBillDbs = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)LOAN_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", BondIds)});
        return loanBillDbs.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
    }

    public void beforeCommit(DynamicObject[] repayBills) throws KDException {
        super.beforeCommit(repayBills);
        for (DynamicObject repayBill : repayBills) {
            if (!repayBill.getBoolean("isbuyback")) continue;
            this.returnBuyBackInvestCreditLimit(repayBill);
        }
    }

    private void returnBuyBackInvestCreditLimit(DynamicObject repayBill) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
            return;
        }
        DynamicObjectCollection entries = repayBill.getDynamicObjectCollection("loans");
        HashMap repayMap = entries.stream().collect(HashMap::new, (k, v) -> k.put(v.getDynamicObject("e_loanbill").getLong("id"), v.getDynamicObjectCollection("buyback_entry")), HashMap::putAll);
        Set loanIds = entries.stream().map(o -> o.getDynamicObject("e_loanbill").getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection bondBills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)BOND_BILL_PROPS_QR, (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)});
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(10);
        List investCreditList = bondBills.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong(String.join((CharSequence)".", "investor_entry", "e_creditlimit")))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> loanAndInvestCreditMap = investCreditList.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(investCreditList.size());
        for (Map.Entry<Long, List<DynamicObject>> loanAndInvestCredit : loanAndInvestCreditMap.entrySet()) {
            Long bondId = loanAndInvestCredit.getKey();
            List<DynamicObject> loadInvestCreditEntry = loanAndInvestCredit.getValue();
            for (DynamicObject loanInvestCredit : loadInvestCreditEntry) {
                DynamicObjectCollection buybackEntries = (DynamicObjectCollection)repayMap.get(loanInvestCredit.getLong("id"));
                for (DynamicObject buybackEntry : buybackEntries) {
                    if (loanInvestCredit.getLong("investor_entry") != buybackEntry.getLong("e_investentryid") || !EmptyUtil.isNoEmpty((BigDecimal)buybackEntry.getBigDecimal("e_buybackamt"))) continue;
                    entryReturnAmtMap.put(loanInvestCredit.getLong("investor_entry"), buybackEntry.getBigDecimal("e_buybackamt"));
                }
            }
            ReturnCreditLimitInfo returnInfo = RepaymentBillBuyBackAuditService.getReturnInfo(repayBill);
            returnInfo.setId(bondId);
            returnInfo.setEntityName("cfm_loanbill_bond");
            returnInfo.setLast(loadInvestCreditEntry.get(0).getBigDecimal("notrepayamount").compareTo(BigDecimal.ZERO) == 0);
            returnInfo.setReturnBillId(bondId);
            returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
            paramList.add(returnInfo);
        }
        if (EmptyUtil.isNoEmpty(paramList)) {
            CreditLimitServiceHelper.batchRreturnCreditLimit(paramList);
        }
    }

    public static ReturnCreditLimitInfo getReturnInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setPreOccupy(false);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setBizBillId((Long)bill.getPkValue());
        param.setReturnTime(bill.getDate("bizdate"));
        return param;
    }
}

