/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.tmc.cfm.extpoint.repay.IRepayBillSecondDevFields;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RepaymentBillSubmitService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("loans.e_loanbill");
        sic.add("loans.e_ispayinst");
        sic.add("loans.e_actintamt");
        sic.add("loans.e_notrepayamount");
        sic.add("loans.e_repayamount");
        sic.add("loans.e_calintamt");
        sic.add("loans.e_combineinst");
        sic.add("bizdate");
        sic.add("amount");
        sic.add("datasource");
        sic.add("org");
        sic.add("creditorg");
        sic.add("registorg");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("returnreason");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("lendernature");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("isrelcash");
        sic.add("needpayamt");
        sic.add("isinit");
        sic.add("issuretyrepay");
        sic.add(String.join((CharSequence)".", "entry_surety", "suretyrepayamt"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            CfmBillCommonHelper.setNeedPayAmt((DynamicObject)dataEntity);
            dataEntity.set("totalamt", (Object)RepaymentbillHelper.getTotalAmt((DynamicObject)dataEntity));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        for (DynamicObject repay : repayBills) {
            for (DynamicObject entry : repay.getDynamicObjectCollection("loans")) {
                if (!entry.getBoolean("e_ispayinst")) continue;
                this.pushInterestBill(repay, entry);
            }
        }
    }

    private void pushInterestBill(DynamicObject repay, DynamicObject entry) {
        Map<Long, BigDecimal> slBankEntryMap;
        DynamicObject loanBankAcct;
        String dataSource = repay.getString("datasource");
        DynamicObject loanBill = entry.getDynamicObject("e_loanbill");
        String loanType = repay.getString("loantype");
        OperateOption create = OperateOption.create();
        this.dealRepaySecondDev(repay, create);
        create.setVariableValue("repaymentFlag", "true");
        create.setVariableValue("ignoreFinLeaseFlag", "true");
        create.setVariableValue("repaymentId", String.valueOf(repay.getPkValue()));
        create.setVariableValue("bizDate", DateUtils.formatString((Date)repay.getDate("bizdate"), (String)"yyyyMMdd"));
        DynamicObject bankAcct = repay.getDynamicObject("accountbank");
        if (bankAcct != null) {
            create.setVariableValue("accountbank", bankAcct.getString("id"));
        }
        if ((loanBankAcct = repay.getDynamicObject("loaneracctbank")) != null) {
            create.setVariableValue("loaneracctbank", loanBankAcct.getString("id"));
        }
        create.setVariableValue("actinterest", entry.getBigDecimal("e_actintamt").toString());
        create.setVariableValue("e_combineinst", entry.getBoolean("e_combineinst") + "");
        create.setVariableValue("repayAmt", entry.getBigDecimal("e_repayamount").toString());
        create.setVariableValue("isrelcash", repay.getString("isrelcash"));
        if (repay.getBoolean("isinit") && LoanTypeEnum.isFinLease((String)loanType)) {
            create.setVariableValue("isFinleaseInit", repay.getString("isinit"));
        }
        if ((slBankEntryMap = this.getSlBankEntryMap(repay, loanBill.getLong("id"))).size() > 0) {
            create.setVariableValue("slbankamount", JSON.toJSONString(slBankEntryMap));
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            TmcOperateServiceHelper.execOperate((String)"push2investinterest", (String)"cim_invest_loanbill", (Object[])new Object[]{loanBill.getPkValue()}, (OperateOption)create);
        } else {
            String loanEntryName = RepaymentbillHelper.getLoanEntryName((String)loanType);
            if ("ifm_repaymentbill".equals(repay.getDataEntityType().getName())) {
                loanEntryName = "ifm_loanbill";
            }
            TmcOperateServiceHelper.execOperate((String)RepaymentbillHelper.getLoanPushInterestOp((String)loanType), (String)loanEntryName, (Object[])new Object[]{loanBill.getPkValue()}, (OperateOption)create);
        }
    }

    private void dealRepaySecondDev(DynamicObject repay, OperateOption create) {
        PluginProxy pluginProxy = PluginProxy.create(IRepayBillSecondDevFields.class, (String)"kd.sdk.tmc.cfm.extpoint.repay.IRepayBillSecondDevFields.repayBillSecondDevFields");
        List result = pluginProxy.callReplace(proxy -> proxy.repayBillSecondDevFields(repay)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        logger.info(String.format("\u5904\u7406\u7ed3\u679c\u53c2\u6570\uff1a%s", result));
        if (EmptyUtil.isNoEmpty(result) && EmptyUtil.isNoEmpty(result.get(0))) {
            Map fields = (Map)result.get(0);
            create.setVariableValue("SecondDevFieldVal", JSON.toJSONString((Object)fields));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }

    private Map<Long, BigDecimal> getSlBankEntryMap(DynamicObject repay, long loanBillId) {
        Map<Long, BigDecimal> slBankMap = new HashMap<Long, BigDecimal>();
        if (!LoanTypeEnum.isBanksLoan((String)repay.getString("loantype"))) {
            return slBankMap;
        }
        DynamicObjectCollection slBankEntrys = repay.getDynamicObjectCollection("slentryentity");
        slBankMap = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == loanBillId && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_bank"))).collect(Collectors.toMap(o -> o.getDynamicObject("s_bank").getLong("id"), o -> o.getBigDecimal("s_repayinst"), (v1, v2) -> v2));
        return slBankMap;
    }
}

