/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUnConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("repayapplyf7");
        sic.add("e_ispayinst");
        sic.add("e_loanbill");
        sic.add("e_repayamount");
        sic.add("billno");
        sic.add("paybill");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DynamicObject> repayBills = Arrays.asList(dataEntities);
        CfmBillCommonHelper.updateApplyBizStatus(repayBills, (String)"repayapplyf7", (String)"cfm_repayapplybill", (String)ApplyBusinessStatusEnum.HANDING.getValue());
        this.unconfirmInterest(repayBills);
        BusinessHelper.clearConfirmInfo(repayBills);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        HashSet loanBillIds = new HashSet(8);
        for (DynamicObject repayBill : dataEntities) {
            loanBillIds.addAll(repayBill.getDynamicObjectCollection("loans").stream().map(d -> d.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet()));
        }
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
        RepayServiceHelper.batchCancelReturnCreditLimit(Arrays.asList(dataEntities));
    }

    private void unconfirmInterest(List<DynamicObject> repayBills) {
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getIsPayIntRepayLoanBillIdMap(repayBills);
        if (repayLoanBillIdMap.isEmpty()) {
            return;
        }
        ArrayList<Long> repayIds = new ArrayList<Long>(repayLoanBillIdMap.keySet());
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        if (repayIds.isEmpty() || loanBillIds.isEmpty()) {
            return;
        }
        QFilter instFilter = new QFilter("repaymentid", "in", repayIds).and(new QFilter("sourcebillid", "in", loanBillIds).and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())));
        List interestBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cfm_interestbill", (QFilter[])instFilter.toArray(), null, (int)-1);
        if (EmptyUtil.isNoEmpty((Object)interestBillIds)) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("repaymentFlag", "true");
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)"cfm_interestbill", (Object[])interestBillIds.toArray(), (OperateOption)create);
            if (!result.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u606f\u5355/\u6536\u606f\u5355\u53d6\u6d88\u786e\u8ba4\u5931\u8d25,\u5931\u8d25\u4fe1\u606f:  %s\u3002", (String)"RepaymentBillUnConfirmService_1", (String)"tmc-cfm-business", (Object[])new Object[0]), result.getMessage()));
            }
        }
    }
}

