/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill.save;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.business.opservice.repaymentbill.save.RepaymentBillSaveParam;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSaveByInitHandler
extends AbstractBusinessBatchHandler {
    private static String[] selectProps = new String[]{"amount", "currency", "bizdate", "drawamount", "billno", "notrepayamount", "creditlimit", "loancontractbill", "investor_entry", "e_creditlimit"};

    public void doProcess(DynamicObject[] dataEntities, BusinessHandleParam param) {
        this.doByInitOnProcess(dataEntities, (RepaymentBillSaveParam)param.getInParam());
    }

    private void doByInitOnProcess(DynamicObject[] dataEntities, RepaymentBillSaveParam param) {
        Map<String, String> operationVariable = param.getOperationVariable();
        for (DynamicObject repayment : dataEntities) {
            String dataSource = repayment.getString("datasource");
            if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
                repayment.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            repayment.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            repayment.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            repayment.set("confirmtime", (Object)DateUtils.getCurrentTime());
            repayment.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            repayment.set("auditor", (Object)RequestContext.get().getCurrUserId());
            repayment.set("auditdate", (Object)DateUtils.getCurrentTime());
            String codeNumber = CodeRuleHelper.generateNumber((String)this.getRepayMentEntityName(repayment), (DynamicObject)repayment, (String)repayment.getDynamicObject("org").getPkValue().toString(), (String)"");
            if (StringUtils.isEmpty((CharSequence)codeNumber)) {
                throw new KDBizException(bizResource.getInbEndinitNorbill());
            }
            repayment.set("billno", (Object)codeNumber);
            repayment.set("bizdate", (Object)this.getDatePro(operationVariable, "repaydate"));
            BigDecimal repayAmount = this.getBigDecimalPro(operationVariable, "repayamount");
            repayment.set("amount", (Object)repayAmount);
            repayment.set("totalamt", (Object)repayAmount);
            repayment.set("lockpayamt", (Object)BigDecimal.ZERO);
            repayment.set("needpayamt", (Object)BigDecimal.ZERO);
            repayment.set("accountbank", (Object)BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(operationVariable.get("loadacctbank")), (String)"bd_accountbanks", (String)"id"));
            repayment.set("isinit", (Object)Boolean.TRUE);
            DynamicObjectCollection entrys = repayment.getDynamicObjectCollection("loans");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                ((DynamicObject)entrys.get(0)).set("e_repayamount", (Object)repayAmount);
                ((DynamicObject)entrys.get(0)).set("e_convertrepayamt", (Object)repayAmount);
                ((DynamicObject)entrys.get(0)).set("e_ispayinst", (Object)Boolean.FALSE);
                ((DynamicObject)entrys.get(0)).set("e_actintamt", (Object)BigDecimal.ZERO);
                ((DynamicObject)entrys.get(0)).set("e_convertactintamt", (Object)BigDecimal.ZERO);
            }
            RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repayment, (String)"e_repayamount", (String)"s_repayamount");
            RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repayment, (String)"e_actintamt", (String)"s_repayinst");
        }
    }

    private BigDecimal getBigDecimalPro(Map<String, String> operationVariable, String pro) {
        if (EmptyUtil.isEmpty((String)operationVariable.get(pro))) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(operationVariable.get(pro));
    }

    private Date getDatePro(Map<String, String> operationVariable, String pro) {
        if (EmptyUtil.isEmpty((String)operationVariable.get(pro))) {
            return null;
        }
        return DateUtils.stringToDate((String)operationVariable.get(pro), (String)"yyyyMMdd");
    }

    private String getRepayMentEntityName(DynamicObject repayBill) {
        String dataSource = repayBill.getString("datasource");
        if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
            return "ifm_repaymentbill";
        }
        return "cfm_repaymentbill";
    }

    public void doBeforeCommit(DynamicObject[] dataEntities, BusinessHandleParam param) {
        for (DynamicObject repayment : dataEntities) {
            long repayId = repayment.getLong("id");
            if (DataSourceEnum.IFM.getValue().equals(repayment.getString("datasource"))) {
                DynamicObject repayBill = TmcDataServiceHelper.loadSingle((Object)repayId, (String)"ifm_repaymentbill");
                DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
                List loanBillIds = entrys.stream().map(o -> o.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toList());
                TmcBotpHelper.saveRelation((String)"cfm_loanbill", loanBillIds, (String)"cfm_repaymentbill", (Long)repayId);
            }
            BusinessHelper.fillConfirmInfo((DynamicObject)repayment);
            this.returnCreditLimit(repayment);
        }
        RepaymentbillHelper.returnGuaranteeUse((DynamicObject[])dataEntities);
    }

    private void returnCreditLimit(DynamicObject repay) {
        for (DynamicObject entry : repay.getDynamicObjectCollection("loans")) {
            DynamicObject entryLoanBill = entry.getDynamicObject("e_loanbill");
            if (EmptyUtil.isEmpty((DynamicObject)entryLoanBill)) continue;
            String entityName = "cfm_loanbill";
            if (LoanTypeEnum.isBond((String)repay.getString("loantype"))) {
                entityName = "cfm_loanbill_bond";
            }
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)entryLoanBill.getPkValue(), (String)entityName, (String)String.join((CharSequence)",", selectProps));
            boolean isHasCreditLimit = this.investorHasCreditLimit(loanBill);
            if (EmptyUtil.isNoEmpty((Object)loanBill.get("creditlimit"))) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)loanBill, null, (boolean)false, (Date)loanBill.getDate("bizdate"));
                BigDecimal repayAmount = entry.getBigDecimal("e_repayamount");
                BigDecimal drawAmount = loanBill.getBigDecimal("drawamount");
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)repay, (DynamicObject)loanBill, (boolean)false, (BigDecimal)repayAmount, (Long)((Long)repay.getPkValue()), (drawAmount.compareTo(repayAmount) == 0 ? 1 : 0) != 0, (Date)repay.getDate("bizdate"));
                continue;
            }
            if (!isHasCreditLimit && !CreditLimitHelper.isEntryCredit((DynamicObject)this.queryLoanContractBill(loanBill), (String)"banksyndicate_entry", (String)"e_creditlimit")) continue;
            RepayServiceHelper.returnCreditLimit(BusinessDataServiceHelper.loadSingle((Object)repay.getPkValue(), (String)repay.getDataEntityType().getName()));
        }
    }

    private boolean investorHasCreditLimit(DynamicObject loanBill) {
        DynamicObjectCollection bankSyndicateEntry;
        List entryCredList;
        return loanBill.containsProperty("investor_entry") && EmptyUtil.isNoEmpty(entryCredList = (bankSyndicateEntry = loanBill.getDynamicObjectCollection("investor_entry")).stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList()));
    }

    private DynamicObject queryLoanContractBill(DynamicObject loanBill) {
        DynamicObject[] loanConArr = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "e_shareamount", "e_creditlimit"), (QFilter[])new QFilter[]{new QFilter("id", "=", loanBill.getDynamicObject("loancontractbill").getPkValue())});
        DynamicObject loanContractBill = loanConArr[0];
        return loanContractBill;
    }

    public boolean doFilter(DynamicObject[] dynamicObjects, BusinessHandleParam param) {
        return ((RepaymentBillSaveParam)param.getInParam()).isByInit();
    }
}

