/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.task;

import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillRateResetUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LoanBillRateResetUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6, param={}", (Object)SerializationUtils.toJsonString(paramMap));
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue())).and("interesttype", "=", (Object)InterestTypeEnum.FLOAT.getValue()).and("rateadjuststyle", "in", Arrays.asList(RateAdjustStyleEnum.CYCLE.getValue(), RateAdjustStyleEnum.DEADLINE.getValue(), RateAdjustStyleEnum.AFTERINT.getValue()));
        if (paramMap != null && !paramMap.isEmpty()) {
            String orgs;
            String billnos;
            String loanTypes = (String)paramMap.get("loantype");
            if (EmptyUtil.isNoEmpty((String)loanTypes)) {
                filter.and(new QFilter("loantype", "in", Arrays.asList(loanTypes.split(","))));
            }
            if (EmptyUtil.isNoEmpty((String)(billnos = (String)paramMap.get("billno")))) {
                filter.and(new QFilter("billno", "in", Arrays.asList(billnos.split(","))));
            }
            if (EmptyUtil.isNoEmpty((String)(orgs = (String)paramMap.get("org")))) {
                Object[] orgIds = Arrays.stream(orgs.split(",")).map(Long::valueOf).toArray();
                filter.and(new QFilter("org", "in", (Object)orgIds));
            }
        }
        logger.info("\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6filter={}", (Object)filter.toString());
        Object[] loanbills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"id,billno,billstatus,loantype,datasource,sourcebillid,drawtype,interesttype", (QFilter[])filter.toArray());
        logger.info("\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6, loanbills={}", (Object)loanbills.length);
        if (EmptyUtil.isNoEmpty((Object[])loanbills)) {
            OperationResult rateadjustTask = TmcOperateServiceHelper.execOperateWithoutThrow((String)"rateadjust_task", (String)"cfm_loanbill", (DynamicObject[])loanbills, (OperateOption)OperateOption.create());
            this.buildLog(rateadjustTask);
            logger.info("\u7ed3\u675f\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6, result={}", (Object)loanbills.length);
        } else {
            logger.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6\u6570\u636e");
        }
    }

    private void buildLog(OperationResult result) {
        logger.info("\u64cd\u4f5c\u540d\u79f0:\u5229\u7387\u91cd\u7f6e\u8c03\u5ea6");
        logger.info("\u6210\u529f\u6761\u6570:" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f:" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f:" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f:" + result.getSponsor());
        logger.info("\u6267\u884c\u5b8c\u6210\u65f6\u95f4" + DateUtils.getCurrentTime());
        if (!result.isSuccess()) {
            logger.info(result.toString());
        }
    }
}

