/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.task;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractAutoCloseTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LoanContractAutoCloseTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        DynamicObject[] contractBills;
        logger.info("\u5f00\u59cb\u5faa\u73af\u8d37\u6b3e\u7684\u5408\u540c\u81ea\u52a8\u7ed3\u6e05\u8c03\u5ea6\u4efb\u52a1, param={}", (Object)SerializationUtils.toJsonString(paramMap));
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and(new QFilter("iscycleloan", "=", (Object)true));
        filter.and(new QFilter("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue()));
        String selects = "id, billno, billstatus, contractstatus, iscycleloan, amount, repayamount, enddate, renewalexpiredate, datasource, ishandend, creditlimit, drawamount, lenderapplyno, loantype, banksyndicate_entry, banksyndicate_entry.e_creditlimit";
        for (DynamicObject contractBill : contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)selects, (QFilter[])filter.toArray())) {
            Date endDate = contractBill.getDate("enddate");
            Date renewalexpireDate = contractBill.getDate("renewalexpiredate");
            Date date = endDate = renewalexpireDate == null ? endDate : renewalexpireDate;
            if (endDate.compareTo(new Date()) > 0) continue;
            BigDecimal contractLoanAmt = contractBill.getBigDecimal("amount");
            BigDecimal contractRepayAmount = contractBill.getBigDecimal("repayamount");
            QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
            DynamicObjectCollection downLoanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,drawtype", (QFilter[])qFilter.toArray());
            boolean isAllCloseLoanBill = true;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)downLoanBills)) {
                isAllCloseLoanBill = downLoanBills.stream().allMatch(o -> DrawTypeEnum.CLOSEOUT.getValue().equals(o.getString("drawtype")));
            }
            if (!isAllCloseLoanBill || contractRepayAmount.compareTo(contractLoanAmt) < 0) continue;
            OperationResult endcontract = TmcOperateServiceHelper.execOperateWithoutThrow((String)"endcontract", (String)contractBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{contractBill}, (OperateOption)OperateOption.create());
            this.buildLog(endcontract);
        }
        logger.info("\u7ed3\u675f\u5faa\u73af\u8d37\u6b3e\u7684\u5408\u540c\u81ea\u52a8\u7ed3\u6e05\u8c03\u5ea6\u4efb\u52a1");
    }

    private void buildLog(OperationResult result) {
        logger.info("\u5408\u540c\u81ea\u52a8\u7ed3\u6e05\u8c03\u5ea6");
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
        logger.info("\u6267\u884c\u5b8c\u6210\u65f6\u95f4" + DateUtils.getCurrentTime());
    }
}

