/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractAutoDrawTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LoanContractAutoDrawTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        DynamicObject[] contractBills;
        logger.info("\u5f00\u59cb\u81ea\u52a8\u63d0\u6b3e\u8c03\u5ea6\u4efb\u52a1, param={}\u3002", (Object)SerializationUtils.toJsonString(paramMap));
        List<Long> contractIds = this.getContractIdsByLoan();
        contractIds.addAll(this.getContractIdsByApply());
        for (DynamicObject contractBill : contractBills = this.getContractBills()) {
            Optional<DynamicObject> firstPlan;
            DynamicObjectCollection drawPlans;
            if (contractIds.contains(contractBill.getLong("id")) || EmptyUtil.isEmpty((DynamicObjectCollection)(drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry"))) || !(firstPlan = drawPlans.stream().filter(dp -> "0".equals(dp.getString("e_drawstate"))).filter(dp -> dp.getDate("e_plandrawdate").compareTo(DateUtils.getCurrentDate()) <= 0).findFirst()).isPresent()) continue;
            OperationResult autoDraw = TmcOperateServiceHelper.execOperateWithoutThrow((String)"autodraw", (String)contractBill.getDataEntityType().getName(), (Object[])new Object[]{contractBill.getPkValue()}, (OperateOption)OperateOption.create());
            this.buildLog(autoDraw);
        }
        logger.info("\u7ed3\u675f\u81ea\u52a8\u63d0\u6b3e\u8c03\u5ea6\u4efb\u52a1\u3002");
    }

    private DynamicObject[] getContractBills() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and(new QFilter("contractstatus", "in", Arrays.asList(LoanContractStatusEnum.REGISTERED.getValue(), LoanContractStatusEnum.EXECUTING.getValue())));
        String selects = "id, billno, drawdownplan_entry, drawdownplan_entry.e_drawstate, drawdownplan_entry.e_plandrawdate";
        DynamicObject[] contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)selects, (QFilter[])filter.toArray());
        return contractBills;
    }

    private List<Long> getContractIdsByLoan() {
        QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"loancontractbill", (QFilter[])filter.toArray());
        List<Long> contractIds = loanBills.stream().map(o -> o.getLong("loancontractbill")).collect(Collectors.toList());
        return contractIds;
    }

    private List<Long> getContractIdsByApply() {
        QFilter filter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue()));
        DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"loancontractbill", (QFilter[])filter.toArray());
        List<Long> contractIds = drawApplyBills.stream().map(o -> o.getLong("loancontractbill")).collect(Collectors.toList());
        return contractIds;
    }

    private void buildLog(OperationResult result) {
        logger.info("\u5408\u540c\u81ea\u52a8\u7ed3\u6e05\u8c03\u5ea6");
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
        logger.info("\u6267\u884c\u5b8c\u6210\u65f6\u95f4" + DateUtils.getCurrentTime());
    }
}

