/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class ConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("confirmstatus");
        sic.add("datasource");
        sic.add("creditortype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource("");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizBill = dataEntity.getDataEntity();
            String creditorType = bizBill.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) continue;
            String confirmstatus = bizBill.getString("confirmstatus");
            if (!StringUtils.equals((CharSequence)ConfirmStatusEnum.WAITCONFIRM.getValue(), (CharSequence)confirmstatus)) {
                this.addErrorMessage(dataEntity, bizResource.getConfirmStatus());
            }
            String dataSource = bizBill.getString("datasource");
            String entityName = bizBill.getDataEntityType().getName();
            if (!BusinessHelper.isSameSource((String)entityName, (String)dataSource)) continue;
            this.addErrorMessage(dataEntity, bizResource.getConfirmSameSourceError());
        }
    }
}

