/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.apply;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplyGenerateContractValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("billstatus");
        selector.add("creditortype");
        selector.add("org");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set<Long> ids = Arrays.stream(dataEntity).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> contractMap = this.queryContract(ids);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject loanApply = data.getDataEntity();
            String billStatus = loanApply.getString("billstatus");
            String creditorType = loanApply.getString("creditortype");
            Long id = loanApply.getLong("id");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u6001\u7684\u878d\u8d44\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u751f\u6210\u501f\u6b3e\u5408\u540c\u3002", (String)"LoanApplyGenerateContractValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u4e0d\u80fd\u76f4\u63a5\u751f\u6210\u5408\u540c\u3002", (String)"LoanApplyGenerateContractValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            DynamicObject mianOrgDy = loanApply.getDynamicObject("company");
            boolean isAllowManyPush = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)mianOrgDy)) {
                isAllowManyPush = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)mianOrgDy.getLong("id"), (String)"cfm010");
            }
            if (isAllowManyPush || !contractMap.containsKey(id)) continue;
            String billNo = contractMap.get(id).getString("billno");
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\u4e86\u5408\u540c\uff1a%1s\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u5408\u540c\u3002", (String)"LoanApplyGenerateContractValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]), billNo));
        }
    }

    private Map<Long, DynamicObject> queryContract(Set<Long> ids) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(4);
        QFilter qFilter = new QFilter("sourcebillid", "in", (Object)ids.toArray());
        Object[] loanContracts = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)"id,sourcebillid,billno", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])loanContracts)) {
            map = Arrays.stream(loanContracts).collect(Collectors.toMap(o -> o.getLong("sourcebillid"), o -> o, (k1, k2) -> k2));
        }
        return map;
    }
}

