/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.apply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cfm.common.enums.GuaranteeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySchemeSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isneedscheme");
        selector.add("entry");
        selector.add("s_number");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String submitByCard = this.getOption().getVariables().getOrDefault("submit_by_card", "");
        if (EmptyUtil.isEmpty((String)submitByCard)) {
            return;
        }
        Map<String, String> mustInputPropMap = this.getMustInputProps();
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject loanApply = data.getDataEntity();
            if (!loanApply.getBoolean("isneedscheme") || !loanApply.getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) continue;
            DynamicObjectCollection schemes = loanApply.getDynamicObjectCollection("entry");
            ArrayList<DynamicObject> waitDelEntry = new ArrayList<DynamicObject>(8);
            for (DynamicObject entry : schemes) {
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("s_entry");
                if (!CollectionUtils.isEmpty((Collection)subEntrys)) continue;
                waitDelEntry.add(entry);
            }
            schemes.removeAll(waitDelEntry);
            if (CollectionUtils.isEmpty((Collection)schemes)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65b9\u6848\u3002", (String)"LoanApplySchemeSaveOrSubmitValidator_21", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            StringJoiner notFilledProps = new StringJoiner("\u3001");
            for (DynamicObject scheme : schemes) {
                String guaranteeWay;
                DynamicObjectCollection subEntrys;
                if (null == scheme || CollectionUtils.isEmpty((Collection)(subEntrys = scheme.getDynamicObjectCollection("s_entry")))) continue;
                DynamicObject schemeBodyInfo = (DynamicObject)subEntrys.get(0);
                for (Map.Entry<String, String> entrySet : mustInputPropMap.entrySet()) {
                    String propName = entrySet.getKey();
                    String entryProp = String.format("s_%s", propName);
                    if ("referrate".equals(propName)) {
                        if (!StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)schemeBodyInfo.getString("s_interesttype")) || !EmptyUtil.isEmpty((Object)schemeBodyInfo.get(entryProp))) continue;
                        notFilledProps.add(entrySet.getValue());
                        continue;
                    }
                    if ("creditor".equals(propName)) {
                        if (StringUtils.equals((CharSequence)CreditorTypeEnum.OTHER.getValue(), (CharSequence)schemeBodyInfo.getString("s_creditortype")) || !EmptyUtil.isEmpty((Object)schemeBodyInfo.get(entryProp))) continue;
                        notFilledProps.add(entrySet.getValue());
                        continue;
                    }
                    if ("textcreditor".equals(propName)) {
                        if (!StringUtils.equals((CharSequence)CreditorTypeEnum.OTHER.getValue(), (CharSequence)schemeBodyInfo.getString("s_creditortype")) || !EmptyUtil.isEmpty((Object)schemeBodyInfo.get(entryProp))) continue;
                        notFilledProps.add(entrySet.getValue());
                        continue;
                    }
                    if ("interestrate".equals(propName)) {
                        if (null != schemeBodyInfo.getBigDecimal("s_interestrate")) continue;
                        notFilledProps.add(entrySet.getValue());
                        continue;
                    }
                    if (EmptyUtil.isEmpty((Object)schemeBodyInfo.getDynamicObjectType().getProperty(entryProp)) || !EmptyUtil.isEmpty((Object)schemeBodyInfo.get(entryProp))) continue;
                    notFilledProps.add(entrySet.getValue());
                }
                DynamicObjectCollection costEntry = scheme.getDynamicObjectCollection("c_entry");
                if (CollectionUtils.isEmpty((Collection)costEntry)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u878d\u8d44\u6210\u672c\u201d\u3002", (String)"LoanApplySchemeSaveOrSubmitValidator_18", (String)"tmc-cfm-business", (Object[])new Object[0]));
                } else {
                    List unFilledCostAmtEntry = costEntry.stream().filter(v -> null == v.getBigDecimal("e_costamt")).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(unFilledCostAmtEntry)) {
                        notFilledProps.add(ResManager.loadKDString((String)"\u201c\u6210\u672c\u91d1\u989d\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_19", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    }
                }
                if (notFilledProps.length() > 0) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%1$s:\u8bf7\u6309\u8981\u6c42\u586b\u5199%2$s\u3002", (String)"LoanApplySchemeSaveOrSubmitValidator_20", (String)"tmc-cfm-business", (Object[])new Object[0]), schemeBodyInfo.getString("s_number"), notFilledProps.toString()));
                }
                if (!EmptyUtil.isNoEmpty((String)(guaranteeWay = schemeBodyInfo.getString("s_guaranteeway"))) || !guaranteeWay.contains(GuaranteeEnum.NONE.getValue()) || !guaranteeWay.contains(GuaranteeEnum.ENSURE.getValue()) && !guaranteeWay.contains(GuaranteeEnum.MORTGAGE.getValue()) && !guaranteeWay.contains(GuaranteeEnum.PLEDGE.getValue()) && !guaranteeWay.contains(GuaranteeEnum.OTHER.getValue())) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e2d\u7684\u4fe1\u7528/\u65e0\u62c5\u4fdd\u4e0d\u80fd\u4e0e\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u3001\u5176\u4ed6\u540c\u65f6\u9009\u62e9\u3002", (String)"LoanApplySchemeSaveOrSubmitValidator_22", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, String> getMustInputProps() {
        HashMap<String, String> mustInputPropMap = new HashMap<String, String>(32);
        mustInputPropMap.put("number", ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("name", ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("loanapply", ResManager.loadKDString((String)"\u201c\u878d\u8d44\u7533\u8bf7\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("finproduct", ResManager.loadKDString((String)"\u201c\u878d\u8d44\u54c1\u79cd\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("fintype", ResManager.loadKDString((String)"\u201c\u878d\u8d44\u4e1a\u52a1\u5206\u7c7b\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("startdate", ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65e5\u671f\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("term", ResManager.loadKDString((String)"\u201c\u671f\u9650\uff08ymd\uff09\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("enddate", ResManager.loadKDString((String)"\u201c\u7ed3\u675f\u65e5\u671f\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("creditortype", ResManager.loadKDString((String)"\u201c\u503a\u6743\u4eba\u7c7b\u578b\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("creditor", ResManager.loadKDString((String)"\u201c\u503a\u6743\u4eba\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("textcreditor", ResManager.loadKDString((String)"\u201c\u503a\u6743\u4eba\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("currency", ResManager.loadKDString((String)"\u201c\u878d\u8d44\u5e01\u79cd\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_11", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("amount", ResManager.loadKDString((String)"\u201c\u878d\u8d44\u91d1\u989d\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_12", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("guaranteeway", ResManager.loadKDString((String)"\u201c\u62c5\u4fdd\u65b9\u5f0f\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_13", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("interesttype", ResManager.loadKDString((String)"\u201c\u5229\u7387\u7c7b\u578b\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_14", (String)"tmc-cfm-business", (Object[])new Object[0]));
        mustInputPropMap.put("interestrate", ResManager.loadKDString((String)"\u201c\u8d37\u6b3e\u5e74\u5229\u7387\uff08%\uff09\u201d", (String)"LoanApplySchemeSaveOrSubmitValidator_15", (String)"tmc-cfm-business", (Object[])new Object[0]));
        return mustInputPropMap;
    }
}

