/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.apply;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("isneedscheme");
        selector.add("creditor");
        selector.add("textcreditor");
        selector.add("repaymentway");
        selector.add("repaymentway");
        selector.add("finproduct");
        selector.add("guarantee");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("entrys");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String submitByCard = this.getOption().getVariables().getOrDefault("submit_by_card", "");
        for (ExtendedDataEntity data : dataEntity) {
            boolean creditorExist;
            DynamicObject loanApply = data.getDataEntity();
            if (loanApply.getBoolean("isneedscheme") && EmptyUtil.isEmpty((String)submitByCard)) {
                DynamicObjectCollection entrys = loanApply.getDynamicObjectCollection("entrys");
                if (!CollectionUtils.isEmpty((Collection)entrys)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65b9\u6848\u3002", (String)"LoanApplySubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            if (loanApply.getBoolean("isneedscheme")) continue;
            String interestType = loanApply.getString("interesttype");
            if (!EmptyUtil.isEmpty((String)interestType) && "fixed".equals(interestType) && null == loanApply.get("interestrate")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d37\u6b3e\u5e74\u5229\u7387\uff08%\uff09\u201d\u3002", (String)"LoanApplySubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            String textCreditor = loanApply.getString("textcreditor");
            if (EmptyUtil.isEmpty((String)textCreditor)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u503a\u6743\u4eba\u201d\u3002", (String)"LoanApplySubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            Date startDate = loanApply.getDate("startdate");
            if (startDate == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanApplySubmitValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            Date endDate = loanApply.getDate("enddate");
            if (endDate == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanApplySubmitValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            if (startDate != null && endDate != null && startDate.compareTo(endDate) > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanApplySubmitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject finProduct = loanApply.getDynamicObject("finproduct");
            if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u878d\u8d44\u54c1\u79cd\u201d\u3002", (String)"LoanApplySubmitValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            String guarantee = loanApply.getString("guarantee");
            if (EmptyUtil.isEmpty((String)guarantee)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u62c5\u4fdd\u65b9\u5f0f\u201d\u3002", (String)"LoanApplySubmitValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            String creditType = loanApply.getString("creditortype");
            String creditName = loanApply.getString("textcreditor");
            if (CreditorTypeEnum.OTHER.getValue().equals(creditType) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{creditType, creditName}) || (creditorExist = TmcDataServiceHelper.exists((String)CreditorTypeEnum.getFormIdByValue((String)creditType), (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)creditName)}))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba'%s'\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"LoanApplySelectSchemeValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{creditName}));
        }
    }
}

