/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bill;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.cfm.common.helper.DefaultProductFactoryHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessInfoSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.seq");
        sic.add("supplychainfin_entry");
        sic.add("tradefin_entry");
        sic.add("e_tf_relatebillno");
        sic.add("e_sc_coreenterprise");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("e_shareamount");
        sic.add("amount");
        sic.add("drawamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (dataEntity.getDataEntity().getDataEntityType().getName().startsWith("ifm_")) break;
            this.validateBankSyndicate(dataEntity);
            this.validateTradeFinSCM(dataEntity);
        }
    }

    private void validateBankSyndicate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection finOrgInfos;
        String bizName;
        BigDecimal bizAmt;
        String entityName;
        if (this.getOperateKey().equalsIgnoreCase("save")) {
            return;
        }
        DynamicObject bizBill = dataEntity.getDataEntity();
        if (!LoanTypeEnum.isBanksLoan((String)bizBill.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection bankEntryDOC = bizBill.getDynamicObjectCollection("banksyndicate_entry");
        BigDecimal totalShareAmt = BigDecimal.ZERO;
        int mbCount = 0;
        int pbCount = 0;
        HashSet bankIds = Sets.newHashSetWithExpectedSize((int)bankEntryDOC.size());
        HashSet duplicateBankIds = Sets.newHashSetWithExpectedSize((int)bankEntryDOC.size());
        for (DynamicObject bankEntryDO : bankEntryDOC) {
            String bankRole = bankEntryDO.getString("e_bankrole");
            if (SlBankRoleEnum.isMb((String)bankRole)) {
                ++mbCount;
            } else if (SlBankRoleEnum.isPb((String)bankRole)) {
                ++pbCount;
            }
            DynamicObject bankDO = bankEntryDO.getDynamicObject("e_bank");
            if (bankDO != null) {
                Long bankId = bankDO.getLong("id");
                if (bankIds.contains(bankId)) {
                    duplicateBankIds.add(bankId);
                } else {
                    bankIds.add(bankId);
                }
            }
            BigDecimal shareAmt = bankEntryDO.getBigDecimal("e_shareamount");
            totalShareAmt = totalShareAmt.add(shareAmt);
        }
        if (bankEntryDOC.stream().filter(row -> EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("e_shareamount"))).count() > 0L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4efd\u989d\u91d1\u989d\u4e3a0\u7684\u94f6\u56e2\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessInfoSaveValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if ("cfm_loanbill_bond".equals(entityName = bizBill.getDynamicObjectType().getName())) {
            bizAmt = bizBill.getBigDecimal("drawamount");
            bizName = ResManager.loadKDString((String)"\u53d1\u884c", (String)"BusinessInfoSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
        } else {
            bizAmt = bizBill.getBigDecimal("amount");
            bizName = ResManager.loadKDString((String)"\u5408\u540c", (String)"BusinessInfoSaveValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]);
        }
        if (bizAmt.compareTo(totalShareAmt) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4efd\u989d\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e%s\u91d1\u989d\u3002", (String)"BusinessInfoSaveValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]), bizName));
        }
        if (mbCount == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u9700\u8981\u5f55\u5165\u4e00\u6761\u7ba1\u7406\u884c\u4fe1\u606f\u3002", (String)"BusinessInfoSaveValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (pbCount == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u6761\u53c2\u4e0e\u884c\u4fe1\u606f\u3002", (String)"BusinessInfoSaveValidator_10", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (mbCount > 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u53ea\u80fd\u6709\u4e00\u5bb6\u7ba1\u7406\u884c\u3002", (String)"BusinessInfoSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (duplicateBankIds.size() > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u4e2d\u5b58\u5728\u91cd\u590d\u94f6\u884c\u3002", (String)"BusinessInfoSaveValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (bankIds.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(finOrgInfos = QueryServiceHelper.query((String)"bd_finorginfo", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bankIds).and("finorgtype.type", "=", (Object)"1")})))) {
            String finName = finOrgInfos.stream().map(o -> o.getString("name")).collect(Collectors.joining("\u3001"));
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.BusinessInfoSaveValidator_11.loadKDString(finName));
        }
    }

    private void validateTradeFinSCM(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        DynamicObject pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)contractBill);
        if (!pfDO.getBoolean("islkbizprop")) {
            return;
        }
        if (pfDO.getBoolean("istradefininfo")) {
            DynamicObjectCollection tradeEntrys = contractBill.getDynamicObjectCollection("tradefin_entry");
            HashSet<String> allBillNoSet = new HashSet<String>();
            HashSet<String> duplicateBillNoSet = new HashSet<String>();
            for (DynamicObject tradeEntry : tradeEntrys) {
                String relateBillNo = tradeEntry.getString("e_tf_relatebillno");
                if (allBillNoSet.contains(relateBillNo)) {
                    duplicateBillNoSet.add(relateBillNo);
                    continue;
                }
                allBillNoSet.add(relateBillNo);
            }
            if (duplicateBillNoSet.size() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d38\u878d\u5173\u8054\u4fe1\u606f\u5b58\u5728\u91cd\u590d\u5173\u8054\u5355\u53f7%s\u3002", (String)"BusinessInfoSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]), String.join((CharSequence)",", duplicateBillNoSet)));
            }
        }
        if (pfDO.getBoolean("isscminfo")) {
            DynamicObjectCollection scEntrys = contractBill.getDynamicObjectCollection("supplychainfin_entry");
            HashSet<Long> enterpriseIdsSet = new HashSet<Long>(16);
            for (DynamicObject scEntry : scEntrys) {
                DynamicObject enterpriseDO = scEntry.getDynamicObject("e_sc_coreenterprise");
                if (!EmptyUtil.isNoEmpty((DynamicObject)enterpriseDO)) continue;
                Long id = enterpriseDO.getLong("id");
                if (enterpriseIdsSet.contains(id)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u878d\u8d44\u6838\u5fc3\u4f01\u4e1a\u5fc5\u987b\u4e3a\u540c\u4e00\u5bb6\u3002", (String)"BusinessInfoSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    break;
                }
                enterpriseIdsSet.add(id);
            }
        }
    }
}

