/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.validate.bill.BusinessInfoSaveValidator;
import kd.tmc.cfm.common.helper.DefaultProductFactoryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessInfoSubmitValidator
extends BusinessInfoSaveValidator {
    @Override
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateMustInput(dataEntity);
        }
        super.validate(extendedDataEntities);
    }

    private void validateMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject contractBill = dataEntity.getDataEntity();
        DynamicObject pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)contractBill);
        if (pfDO.getBoolean("islkbizprop") && pfDO.getBoolean("isslinfo")) {
            DynamicObjectCollection bankEntryDOC = contractBill.getDynamicObjectCollection("banksyndicate_entry");
            for (DynamicObject bankEntryDO : bankEntryDOC) {
                String bankRole = bankEntryDO.getString("e_bankrole");
                DynamicObject bankDO = bankEntryDO.getDynamicObject("e_bank");
                int seq = bankEntryDO.getInt("seq");
                if (EmptyUtil.isEmpty((String)bankRole)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u7b2c%s\u884c \u94f6\u884c\u89d2\u8272\u4e3a\u7a7a\u3002", (String)"BusinessInfoSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]), seq));
                }
                if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u7b2c%s\u884c \u94f6\u884c\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"BusinessInfoSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), seq));
            }
        }
    }
}

