/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bond;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("investor_entry");
        sic.add("e_investamount");
        sic.add("e_investortype");
        sic.add("e_investorname");
        sic.add("e_investorid");
        sic.add("drawamount");
        sic.add("finproduct");
        sic.add("firstredeemdate");
        sic.add("startintdate");
        sic.add("bizdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject finProduct;
            DynamicObject bill = dataEntity.getDataEntity();
            BigDecimal amount = bill.getBigDecimal("drawamount");
            DynamicObjectCollection investEntrys = bill.getDynamicObjectCollection("investor_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)investEntrys)) {
                BigDecimal investTotalAmt = investEntrys.stream().map(o -> o.getBigDecimal("e_investamount")).reduce(BigDecimal::add).get();
                if (!Boolean.parseBoolean((String)this.getOption().getVariables().get("byinit")) && investTotalAmt.compareTo(amount) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u8981\u6295\u8d44\u4eba\u7684\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u884c\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BondBillSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
                HashSet<String> investSet = new HashSet<String>(investEntrys.size());
                for (int i = 0; i < investEntrys.size(); ++i) {
                    DynamicObject investEntry = (DynamicObject)investEntrys.get(i);
                    String investType = investEntry.getString("e_investortype");
                    String prop = CreditorTypeEnum.OTHER.getValue().equals(investType) ? "e_investorname" : "e_investorid";
                    String key = investType + investEntry.get(prop);
                    if (investSet.contains(key)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u6295\u8d44\u4eba\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BondBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{i + 1}));
                        continue;
                    }
                    investSet.add(key);
                }
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(finProduct = bill.getDynamicObject("finproduct")))) continue;
            boolean isPerpetual = finProduct.getBoolean("perpetualbond");
            Date firstRedeemDate = bill.getDate("firstredeemdate");
            Date startintdate = bill.getDate("startintdate");
            Date bizdate = bill.getDate("bizdate");
            if (!isPerpetual || EmptyUtil.isEmpty((Object)firstRedeemDate) || !firstRedeemDate.before(startintdate) && !firstRedeemDate.before(bizdate)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9996\u6b21\u8d4e\u56de\u65e5\u671f\u9700\u8981\u5927\u4e8e\u8d77\u606f\u65e5\u671f\u548c\u53d1\u884c\u65e5\u671f\u3002", (String)"BondBillSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

