/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.contractapply;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class ContractApplyUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("loancontractbill");
        sl.add("creditortype");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if ("back".equals(this.getOption().getVariables().get("back"))) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject applyBill = extendedDataEntity.getDataEntity();
            long applyBillId = applyBill.getLong("id");
            DynamicObject loanContractF7 = applyBill.getDynamicObject("loancontractbill");
            if (this.checkTargetBills(extendedDataEntity, applyBill)) continue;
            if (QueryServiceHelper.exists((String)"cfm_contract_apply", (QFilter[])new QFilter[]{new QFilter("loancontractbill", "=", loanContractF7.getPkValue()).and("bizstatus", "!=", (Object)ApplyBizStatusEnum.DONE.getValue())})) {
                boolean isFlApply = applyBill.getDynamicObjectType().getName().equals("fl_contract_apply");
                CfmBusinessResourceEnum errorMsgEnum = isFlApply ? CfmBusinessResourceEnum.ContractApplyUnAuditValidator_3 : CfmBusinessResourceEnum.ContractApplyUnAuditValidator_0;
                this.addErrorMessage(extendedDataEntity, errorMsgEnum.loadKDString(loanContractF7.get("number")));
                continue;
            }
            DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"cfm_contract_apply", (String)"id", (QFilter[])new QFilter[]{new QFilter("loancontractbill", "=", loanContractF7.getPkValue())}, (String)"modifytime desc", (int)1);
            if (applyBillId == ((DynamicObject)applyBills.get(0)).getLong("id")) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%s\u5b58\u5728\u591a\u5f20\u7533\u8bf7\u5355\uff0c\u5fc5\u987b\u6309\u5012\u5e8f\u987a\u5e8f\u4f9d\u6b21\u53cd\u5ba1\u6838\u3002", (String)"ContractApplyUnAuditValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{loanContractF7.get("number")}));
        }
    }

    private boolean checkTargetBills(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        String checkTargetBillsMsg;
        String creditorType = applyBill.getString("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType) && StringUtils.isNotBlank((CharSequence)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)applyBill.getDataEntityType().getName(), (Long)applyBill.getLong("id"), null)))) {
            this.addErrorMessage(dataEntity, checkTargetBillsMsg);
            return true;
        }
        return false;
    }
}

