/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.contractbill;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractAutoDrawValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("confirmstatus");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("drawdownplan_entry");
        sic.add("drawdownplan_entry.e_drawstate");
        sic.add("drawdownplan_entry.e_plandrawdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            Optional<DynamicObject> firstPlan;
            DynamicObject contractBill = entity.getDataEntity();
            String dataSource = contractBill.getString("datasource");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            if (!BillStatusEnum.AUDIT.getValue().equals(contractBill.getString("billstatus"))) {
                this.addErrorMessage(entity, bizResource.getCbStatusError());
            }
            String confirmStatus = contractBill.getString("confirmstatus");
            if (!ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus)) {
                this.addErrorMessage(entity, bizResource.getCbContractStatusError());
            }
            String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)dataSource);
            DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)drawPlans)) {
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ContractAutoDrawValidator_1.loadKDString(loanName, loanName));
            }
            if (!(firstPlan = drawPlans.stream().filter(dp -> "0".equals(dp.getString("e_drawstate"))).filter(dp -> dp.getDate("e_plandrawdate").compareTo(DateUtils.getCurrentDate()) <= 0).findFirst()).isPresent()) {
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ContractAutoDrawValidator_2.loadKDString(loanName, loanName));
            }
            QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
            QFilter confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"billno", (QFilter[])new QFilter[]{qFilter, confirmFilter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBills)) {
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ContractAutoDrawValidator_3.loadKDString(loanName, ((DynamicObject)loanBills.get(0)).getString("billno")));
                return;
            }
            QFilter applyFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
            QFilter businessFilter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue()));
            DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"billno", (QFilter[])new QFilter[]{applyFilter, businessFilter});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)drawApplyBills)) continue;
            this.addErrorMessage(entity, CfmBusinessResourceEnum.ContractAutoDrawValidator_4.loadKDString(((DynamicObject)drawApplyBills.get(0)).getString("billno")));
        }
    }
}

