/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extendbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtendBillConfirmValidator
extends AbstractTmcBizOppValidator {
    private static String[] queryProps = new String[]{"billstatus", "drawtype", "billno", "confirmstatus"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbilllist");
        sic.add("loanbilllist.drawbillid");
        sic.add("loanbilllist.isrenewal");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("loantype");
        sic.add("loancontractbill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter applyFiter;
            DynamicObject extendBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(extendBill.getString("datasource"));
            DynamicObject contractF7 = extendBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractF7) && TmcDataServiceHelper.exists((String)"cfm_extendapplybill", (QFilter[])(applyFiter = new QFilter("loancontractbill", "=", contractF7.getPkValue()).and("billstatus", "in", Arrays.asList(BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()))).toArray())) {
                this.addErrorMessage(dataEntity, bizResource.getIngExtApplyBill());
                continue;
            }
            DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
            ArrayList<Long> pkList = new ArrayList<Long>();
            for (DynamicObject entry : entrys) {
                if (!entry.getBoolean("isrenewal")) continue;
                pkList.add(entry.getLong("drawbillid"));
            }
            if (CollectionUtils.isEmpty(pkList)) continue;
            QFilter pkFilter = new QFilter("id", "in", pkList);
            CharSequence[] selectProperties = queryProps;
            DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{pkFilter});
            for (DynamicObject loanBill : loanBills) {
                if (!StringUtils.equals((CharSequence)ConfirmStatusEnum.YETCONFIRM.getValue(), (CharSequence)loanBill.getString("confirmstatus"))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getEbEntryExisunconfirm(), loanBill.getString("billno")));
                }
                if (!StringUtils.equals((CharSequence)DrawTypeEnum.CLOSEOUT.getValue(), (CharSequence)loanBill.getString("drawtype"))) continue;
                this.addErrorMessage(dataEntity, String.format(bizResource.getEbEntryExisclosed(), loanBill.getString("billno")));
            }
        }
    }
}

