/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feeshare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeShareSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("feeamount");
        selector.add("amount");
        selector.add("billno");
        selector.add("day");
        selector.add("sourcebillid");
        selector.add("org");
        selector.add("currency");
        selector.add("entryentity");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject currency;
            DynamicObject data = dataEntity.getDataEntity();
            if (data.getInt("day") > 0) continue;
            BigDecimal feeAmount = data.getBigDecimal("feeamount");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"FeeShareSubmitValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection loandArr = QueryServiceHelper.query((String)"cfm_loanbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", data.get("sourcebillid"))});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loandArr)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5355[%s]\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FeeShareSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[]{data.getString("billno")}));
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(((DynamicObject)loandArr.get(0)).get("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5355[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u8d39\u7528\u644a\u9500\u3002", (String)"FeeShareSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{data.getString("billno")}));
                continue;
            }
            boolean isHasCost = TmcDataServiceHelper.exists((String)"cfm_loanfeeshare", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", data.get("sourcebillid")), new QFilter("id", "!=", data.getPkValue())});
            if (isHasCost) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u63d0\u6b3e\u5355\u5df2\u5b58\u5728\u8d39\u7528\u644a\u9500\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FeeShareSubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if ((currency = data.getDynamicObject("currency")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5e01\u79cd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FeeShareSubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal feeTotalAmt = CostShareServiceHelper.getFeeAmount((Long)data.getLong("sourcebillid"), (Long)data.getDynamicObject("org").getLong("id"), (Long)currency.getLong("id"), (String)"cfm");
            if (feeTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355[%s]\u5173\u8054\u7684\u8d39\u7528\u644a\u9500\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d39\u7528\u644a\u9500\u3002", (String)"FeeShareSubmitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[]{data.getString("billno")}));
            }
            if (feeAmount.compareTo(feeTotalAmt) == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u644a\u9500\u603b\u989d[%s]\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u8d39\u7528\u644a\u9500\u6570\u636e\u3002", (String)"FeeShareSubmitValidator_5", (String)"tmc-cfm-business", (Object[])new Object[]{feeTotalAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP)}), new Object[0]));
        }
    }
}

