/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillBizInfoTabSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.seq");
        sic.add("supplychainfin_entry");
        sic.add("tradefin_entry");
        sic.add("e_tf_relatebillno");
        sic.add("e_sc_coreenterprise");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("e_shareamount");
        sic.add("amount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateMustInput(dataEntity);
            this.validateBankSyndicate(dataEntity);
            this.validateTradeFinSCM(dataEntity);
            this.validateSupplyChain(dataEntity);
        }
    }

    private void validateMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        DynamicObjectCollection bankEntryDOC = initBill.getDynamicObjectCollection("banksyndicate_entry");
        for (DynamicObject bankEntryDO : bankEntryDOC) {
            String bankRole = bankEntryDO.getString("e_bankrole");
            DynamicObject bankDO = bankEntryDO.getDynamicObject("e_bank");
            int seq = bankEntryDO.getInt("seq");
            if (EmptyUtil.isEmpty((String)bankRole)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u7b2c%s\u884c \u94f6\u884c\u89d2\u8272\u4e3a\u7a7a\u3002", (String)"BusinessInfoSubmitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]), seq));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u7b2c%s\u884c \u94f6\u884c\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"BusinessInfoSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), seq));
        }
    }

    private void validateBankSyndicate(ExtendedDataEntity dataEntity) {
        DynamicObject bizBill = dataEntity.getDataEntity();
        DynamicObjectCollection bankEntryDOC = bizBill.getDynamicObjectCollection("banksyndicate_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)bankEntryDOC)) {
            return;
        }
        BigDecimal totalShareAmt = BigDecimal.ZERO;
        int mbCount = 0;
        for (DynamicObject bankEntryDO : bankEntryDOC) {
            String bankRole = bankEntryDO.getString("e_bankrole");
            if ("MB".equals(bankRole)) {
                ++mbCount;
            }
            BigDecimal shareAmt = bankEntryDO.getBigDecimal("e_shareamount");
            totalShareAmt = totalShareAmt.add(shareAmt);
        }
        BigDecimal bizAmt = bizBill.getBigDecimal("amount");
        String bizName = ResManager.loadKDString((String)"\u5408\u540c", (String)"BusinessInfoSaveValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]);
        if (bizAmt.compareTo(totalShareAmt) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u56e2\u4efd\u989d\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e%s\u91d1\u989d\u3002", (String)"BusinessInfoSaveValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]), bizName));
        }
        if (mbCount > 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u53ea\u80fd\u6709\u4e00\u5bb6\u7ba1\u7406\u884c\u3002", (String)"BusinessInfoSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (bankEntryDOC.stream().filter(row -> EmptyUtil.isNoEmpty((Object)row.get("e_bank"))).collect(Collectors.groupingBy(row -> row.get("e_bank"))).values().stream().filter(v -> v.size() > 1).count() > 0L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u56e2\u4fe1\u606f\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u94f6\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitBillBizInfoTabSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateTradeFinSCM(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        DynamicObjectCollection tradeEntrys = initBill.getDynamicObjectCollection("tradefin_entry");
        HashSet<String> allBillNoSet = new HashSet<String>();
        HashSet<String> duplicateBillNoSet = new HashSet<String>(16);
        for (DynamicObject tradeEntry : tradeEntrys) {
            String relateBillNo = tradeEntry.getString("e_tf_relatebillno");
            if (allBillNoSet.contains(relateBillNo)) {
                duplicateBillNoSet.add(relateBillNo);
                continue;
            }
            allBillNoSet.add(relateBillNo);
        }
        if (duplicateBillNoSet.size() > 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d38\u878d\u5173\u8054\u4fe1\u606f\u5b58\u5728\u91cd\u590d\u5173\u8054\u5355\u53f7%s\u3002", (String)"BusinessInfoSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]), String.join((CharSequence)",", duplicateBillNoSet)));
        }
    }

    private void validateSupplyChain(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        DynamicObjectCollection scEntrys = initBill.getDynamicObjectCollection("supplychainfin_entry");
        HashSet<Long> enterpriseIdsSet = new HashSet<Long>(16);
        for (DynamicObject scEntry : scEntrys) {
            DynamicObject enterpriseDO = scEntry.getDynamicObject("e_sc_coreenterprise");
            if (!EmptyUtil.isNoEmpty((DynamicObject)enterpriseDO)) continue;
            Long id = enterpriseDO.getLong("id");
            if (enterpriseIdsSet.contains(id)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u878d\u8d44\u6838\u5fc3\u4f01\u4e1a\u5fc5\u987b\u4e3a\u540c\u4e00\u5bb6\u3002", (String)"BusinessInfoSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
                break;
            }
            enterpriseIdsSet.add(id);
        }
    }
}

