/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillDisEndInitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("initstatus");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            Boolean interestBills;
            DynamicObject initBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
            String initStatus = initBill.getString("initstatus");
            if (!InitStatusEnum.INITED.getValue().equals(initStatus)) {
                this.addErrorMessage(dataEntity, bizResource.getInbDisendinitInitstatus());
                continue;
            }
            Long initId = (Long)initBill.getPkValue();
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"", (QFilter[])new QFilter[]{new QFilter("initid", "=", (Object)initId)});
            if (EmptyUtil.isEmpty((DynamicObject)contractBill)) continue;
            DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)String.join((CharSequence)",", "id", "isinit"), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", contractBill.getPkValue())});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loanBills)) continue;
            for (DynamicObject loanBill : loanBills) {
                if (loanBill.getBoolean("isinit")) continue;
                this.addErrorMessage(dataEntity, bizResource.getInbDisendinit1bill());
                continue block0;
            }
            for (DynamicObject loanBill : loanBills) {
                Boolean repaymentBills = TmcDataServiceHelper.exists((String)"cfm_repaymentbill", (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "=", loanBill.get("id")), new QFilter("isinit", "=", (Object)"0")});
                if (!Boolean.TRUE.equals(repaymentBills)) continue;
                this.addErrorMessage(dataEntity, bizResource.getInbDisendinitRbill());
                continue block0;
            }
            for (DynamicObject loanBill : loanBills) {
                interestBills = TmcDataServiceHelper.exists((String)"cfm_interestbill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", loanBill.get("id")), new QFilter("isinit", "=", (Object)"0")});
                if (!Boolean.TRUE.equals(interestBills)) continue;
                this.addErrorMessage(dataEntity, bizResource.getInbDisendinitIbILL());
                continue block0;
            }
            for (DynamicObject loanBill : loanBills) {
                interestBills = TmcDataServiceHelper.exists((String)"cfm_preinterestbill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", loanBill.get("id"))});
                if (!Boolean.TRUE.equals(interestBills)) continue;
                this.addErrorMessage(dataEntity, bizResource.getInbDisendinitPbill());
                continue block0;
            }
            List loanBillIds = loanBills.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("unifyloanfrom_entry.e_loanbillid", "in", loanBillIds);
            DynamicObjectCollection unifyCols = QueryServiceHelper.query((String)"cfm_loanbill", (String)"billno", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)unifyCols)) continue;
            String billNos = unifyCols.stream().map(r -> r.getString("billno")).collect(Collectors.joining(","));
            this.addErrorMessage(dataEntity, bizResource.getExistsUnifyRelation(billNos));
        }
    }
}

