/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DtxLockCheckValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String innerAutoPushFlag = (String)variables.get("settleautopush");
        if (EmptyUtil.isEmpty((String)innerAutoPushFlag)) {
            List ids = Arrays.stream(dataEntity).map(v -> v.getDataEntity().getString("id")).collect(Collectors.toList());
            List lockedIds = TxCheckUtil.getLocked(ids);
            for (ExtendedDataEntity extendData : dataEntity) {
                DynamicObject data = extendData.getDataEntity();
                if (!lockedIds.contains(data.getString("id"))) continue;
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5ba1\u6838\u4e0b\u63a8%s\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\u6267\u884c\u5931\u8d25\u6216\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"InterestBillDistTransactionValidator_0", (String)"tmc-cfm-business", (Object[])new Object[]{this.getCasBillName(data)}));
            }
        }
    }

    private String getCasBillName(DynamicObject data) {
        String entityName = data.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_loanbill") || StringUtils.equals((CharSequence)entityName, (CharSequence)"cfm_loanbill")) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u5904\u7406", (String)"InterestBillDistTransactionValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406", (String)"InterestBillDistTransactionValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
    }
}

