/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("instbillctg");
        sic.add("billstatus");
        sic.add("sourcebillid");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("repaymentFlag", "false")) || EmptyUtil.isNoEmpty((String)((String)this.getOption().getVariables().get("repayAutoConfirm")))) {
            return;
        }
        Set sourceBillIds = Arrays.stream(dataEntities).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", sourceBillIds).and("drawtype", "=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        Map loanBillMap = LoanBillRepository.getLoanBillByFilter((QFilter)qFilter, (String)"id");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long sourceBillId = dataEntity.getDataEntity().getLong("sourcebillid");
            if (!loanBillMap.containsKey(sourceBillId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u5df2\u7ed3\u6e05,\u8be5\u5355\u636e\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"InterestBillAuditValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

