/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSlSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("slentryentity");
        sel.add("s_repayinst");
        sel.add("s_bank");
        sel.add("s_loanbillno");
        sel.add("s_convertintamt");
        sel.add("actualinstamt");
        sel.add("convertintamt");
        sel.add("currency");
        sel.add("loancurrency");
        sel.add("loantype");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            int currencyPresion;
            DynamicObjectCollection slBankEntrys;
            DynamicObject data = dataEntity.getDataEntity();
            if (!LoanTypeEnum.isBanksLoan((String)data.getString("loantype")) || EmptyUtil.isEmpty((DynamicObjectCollection)(slBankEntrys = data.getDynamicObjectCollection("slentryentity")))) continue;
            BigDecimal repayIntAmount = slBankEntrys.stream().map(o -> o.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal repayCoverAmount = slBankEntrys.stream().map(o -> o.getBigDecimal("s_convertintamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal actualAmt = data.getBigDecimal("actualinstamt");
            BigDecimal convertAmt = data.getBigDecimal("convertintamt");
            if (repayIntAmount.compareTo(actualAmt) != 0) {
                currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)data.getDynamicObject("currency"));
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillSlSubmitValidator_0.loadKDString(repayIntAmount.setScale(currencyPresion), actualAmt.setScale(currencyPresion)));
            }
            if (repayCoverAmount.compareTo(convertAmt) == 0) continue;
            currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)data.getDynamicObject("loancurrency"));
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.LoanIntBillSlSubmitValidator_0.loadKDString(repayCoverAmount.setScale(currencyPresion), convertAmt.setScale(currencyPresion)));
        }
    }
}

