/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("billstatus");
        sic.add("sourcebillid");
        sic.add("loandate");
        sic.add("bizdate");
        sic.add("startinstdate");
        sic.add("endinstdate");
        sic.add("actualinstamt");
        sic.add("instbankacct");
        sic.add("datasource");
        sic.add("loaneracctbank");
        sic.add("isoverseaentfill");
        sic.add("org");
        sic.add("creditorg");
        sic.add("predictinstamt");
        sic.add("convertintamt");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        this.validateHasUnConfirmBill(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateIntAmountValiation(dataEntity);
        }
        Map<Long, ExtendedDataEntity> dataEntityMap = Arrays.stream(dataEntities).collect(Collectors.toMap(d -> d.getDataEntity().getLong("id"), d -> d));
        Map validateResults = InterestValidateHelper.batchValidateOnSaveBill((ExtendedDataEntity[])dataEntities);
        for (Map.Entry entry : validateResults.entrySet()) {
            ExtendedDataEntity dataEntity = dataEntityMap.get(entry.getKey());
            for (ValidateBean p : (List)entry.getValue()) {
                this.addMessage(dataEntity, p.getErrorInfo(), "error".equals(p.getErrorType()) ? ErrorLevel.Error : ErrorLevel.Warning);
            }
        }
    }

    private AbstractBizResource getBizResource(DynamicObject interestEntity) {
        return new BizResourceFactory().getBizResource(interestEntity.getString("datasource"));
    }

    private void validateHasUnConfirmBill(ExtendedDataEntity[] dataEntities) {
        Map<Long, List<ExtendedDataEntity>> interestBillMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> d.getDataEntity().getLong("sourcebillid")));
        QFilter ingFilter = new QFilter("sourcebillid", "in", interestBillMap.keySet());
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).or("confirmstatus", "in", Arrays.asList(ConfirmStatusEnum.WAITCONFIRM.getValue(), ConfirmStatusEnum.REGISTRYING.getValue()));
        DynamicObjectCollection submitInterestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,sourcebillid,billno", (QFilter[])new QFilter[]{ingFilter, statusFilter});
        Map<Long, List<DynamicObject>> interestLoanMap = submitInterestBills.stream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : interestLoanMap.entrySet()) {
            Long loanBillId = entry.getKey();
            List<ExtendedDataEntity> dataEntityList = interestBillMap.get(loanBillId);
            for (ExtendedDataEntity dataEntity : dataEntityList) {
                long interestBillId = dataEntity.getDataEntity().getLong("id");
                String billNos = entry.getValue().stream().filter(d -> d.getLong("id") != interestBillId).map(d -> d.getString("billno")).collect(Collectors.joining(","));
                if (!EmptyUtil.isNoEmpty((String)billNos)) continue;
                this.addErrorMessage(dataEntity, String.format(this.getBizResource(dataEntity.getDataEntity()).getIbSubmitOnlyoneValidator(), billNos));
            }
        }
    }

    private void validateIntAmountValiation(ExtendedDataEntity dataEntity) {
        DynamicObject interestEntity = dataEntity.getDataEntity();
        DynamicObject org = interestEntity.getDynamicObject("org");
        if (DataSourceEnum.isInvest((String)interestEntity.getString("datasource"))) {
            org = interestEntity.getDynamicObject("creditorg");
        }
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return;
        }
        long orgId = org.getLong("id");
        if (!CfmSysParamHelper.getAppBoolParameter((long)orgId, (String)"cfm007")) {
            return;
        }
        BigDecimal controlAmt = CfmSysParamHelper.getAppBigDecimalParameter((long)orgId, (String)"cfm008");
        BigDecimal predictInstAmt = interestEntity.getBigDecimal("predictinstamt");
        BigDecimal convertIntAmt = interestEntity.getBigDecimal("convertintamt");
        BigDecimal abs = convertIntAmt.subtract(predictInstAmt).abs().setScale(2, RoundingMode.HALF_UP);
        if (abs.compareTo(controlAmt) > 0) {
            String dataSource = interestEntity.getString("datasource");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u6d4b\u7b97\u5229\u606f\u91d1\u989d\u4e4b\u5dee\u7edd\u5bf9\u503c%2$s\u4e0d\u80fd\u5927\u4e8e\u53c2\u6570\u8bbe\u7f6e\u7684\u5141\u8bb8\u504f\u5dee\u91d1\u989d%3$s\uff0c\u8bf7\u4fee\u6539\u4ed8\u606f\u91d1\u989d\u3002", (String)"InterestBillSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]), InterestValidateHelper.getFieldName((String)dataSource), abs, controlAmt));
        }
    }
}

