/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.interestbill.InterestBillUnAuditOrConfirmValidator;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillUnAuditValidator
extends InterestBillUnAuditOrConfirmValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("instbillctg");
        sic.add("loanbillno");
        sic.add("sourcebillid");
        sic.add("id");
        sic.add("billstatus");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("datasource");
        sic.add("contractbillno");
        sic.add("creditortype");
        sic.add("repaymentid");
        sic.add("isoverseaentfill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        OperateOption option = this.getOption();
        if ("true".equals(option.getVariableValue("repaymentFlag", "false"))) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntities);
        dataEntityList = this.validateLoanContract(dataEntityList);
        dataEntityList = this.validateForPrePayInt(dataEntityList);
        dataEntityList = this.validateOnUnAudit(dataEntityList);
        dataEntityList = this.validateTargetBill(dataEntityList);
        dataEntityList = this.validatePayCorAndInt(dataEntityList, Boolean.FALSE);
    }

    private List<ExtendedDataEntity> validateForPrePayInt(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities) || this.getOption().containsVariable("ykx_fromLoanBill")) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (LoanBillHelper.isPrePayint((String)dataEntity.getDataEntity().getString("instbillctg"))) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillUnAuditValidator_2.loadKDString());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateOnUnAudit(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List interestBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map validateBeanMap = InterestValidateHelper.validateOnUnAudit(interestBills);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long interestBillId = dataEntity.getDataEntity().getLong("id");
            ValidateBean validateBean = (ValidateBean)validateBeanMap.get(interestBillId);
            if (validateBean != null) {
                this.addMessage(dataEntity, validateBean.getErrorInfo(), validateBean.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateTargetBill(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        List interestBillIds = dataEntities.stream().filter(d -> this.isSettleCenter(d.getDataEntity())).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (interestBillIds.isEmpty()) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        Set<String> includeTargetEntitys = Collections.singleton("ifm_bizdealbill");
        HashSet<String> excludeTargetEntitys = new HashSet<String>(2);
        excludeTargetEntitys.add("ifm_rectransbill");
        excludeTargetEntitys.add("ifm_transhandlebill");
        Map targetBillNoMap = TmcBotpHelper.getTargetBillNoMap((String)"cfm_interestbill", interestBillIds, excludeTargetEntitys, includeTargetEntitys, null);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long interestBillId = dataEntity.getDataEntity().getLong("id");
            Map billNoMap = (Map)targetBillNoMap.get(interestBillId);
            if (EmptyUtil.isEmpty((Object)billNoMap)) continue;
            List billNos = (List)billNoMap.get("ifm_bizdealbill");
            if (EmptyUtil.isNoEmpty((Object)billNos)) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.InterestBillUnAuditValidator_1.loadKDString(String.join((CharSequence)",", billNos)));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean isSettleCenter(DynamicObject bill) {
        return CreditorTypeEnum.SETTLECENTER.getValue().equals(bill.getString("creditortype"));
    }
}

