/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.validate.interestbill.InterestBillUnAuditOrConfirmValidator;
import kd.tmc.cfm.common.bean.ValidateBean;
import kd.tmc.cfm.common.helper.InterestValidateHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillUnConfirmValidator
extends InterestBillUnAuditOrConfirmValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("instbillctg");
        sic.add("loanbillno");
        sic.add("sourcebillid");
        sic.add("repaymentid");
        sic.add("id");
        sic.add("billstatus");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("datasource");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("contractbillno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("repaymentFlag", "false"))) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntities);
        dataEntityList = this.validateLoanContract(dataEntityList);
        dataEntityList = this.validateOnUnConfirm(dataEntityList);
        dataEntityList = this.validatePayCorAndInt(dataEntityList, Boolean.TRUE);
    }

    @Override
    protected List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject interestBill = dataEntity.getDataEntity();
            if (interestBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, this.getBizResource(interestBill).getIbUnauditContractinit());
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateOnUnConfirm(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        List interestBills = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map validateBeanMap = InterestValidateHelper.validateOnUnConfirm(interestBills, (Boolean)Boolean.FALSE);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long interestBillId = dataEntity.getDataEntity().getLong("id");
            ValidateBean validateBean = (ValidateBean)validateBeanMap.get(interestBillId);
            if (validateBean != null) {
                this.addMessage(dataEntity, validateBean.getErrorInfo(), validateBean.isError() ? ErrorLevel.Error : ErrorLevel.Warning);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

