/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.interestbill;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;

public class InterestCalValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("bizdate");
        sic.add("loandate");
        sic.add("startinstdate");
        sic.add("endinstdate");
        sic.add("billstatus");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("byInit", "false"))) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter qFilter;
            DynamicObject interestEntity = dataEntity.getDataEntity();
            String billstatus = interestEntity.getString("billstatus");
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(interestEntity.getString("datasource"));
            if (BillStatusEnum.isAudit((String)billstatus)) {
                this.addErrorMessage(dataEntity, bizResource.getIbAUDITCalValidator());
                continue;
            }
            Date bizdate = interestEntity.getDate("bizdate");
            Date loandate = interestEntity.getDate("loandate");
            Date startinstdate = interestEntity.getDate("startinstdate");
            Date endinstdate = interestEntity.getDate("endinstdate");
            if (bizdate.compareTo(loandate) <= 0 && !QueryServiceHelper.exists((String)"cfm_loanbill", (QFilter[])(qFilter = new QFilter("id", "=", (Object)interestEntity.getLong("sourcebillid")).and("settleintmode", "=", (Object)SettleIntModeEnum.ykx.getValue())).toArray())) {
                this.addErrorMessage(dataEntity, bizResource.getIbSavePaydateecompValidator());
            }
            if (endinstdate == null || startinstdate == null || endinstdate.compareTo(startinstdate) >= 0) continue;
            this.addErrorMessage(dataEntity, bizResource.getIbSaveEndmorestartValidator());
        }
    }
}

