/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchLoanAutoInterestValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("drawtype");
        selector.add("confirmstatus");
        selector.add("productfactory");
        selector.add("repaymentway");
        selector.add("datasource");
        selector.add("interest_entry");
        selector.add("loantype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            QFilter confirmFilter;
            QFilter loanbillnoFilter;
            DynamicObjectCollection submitInterestBills;
            DynamicObject productFactory;
            DynamicObject data = entity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            String drawType = data.getString("drawtype");
            ArrayList status = Lists.newArrayList((Object[])new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue(), DrawTypeEnum.ALLPAYMENT.getValue()});
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus")) || !status.contains(drawType)) {
                this.addErrorMessage(entity, bizResource.getLoanInterestStatus());
            }
            String confirmStatus = data.getString("confirmstatus");
            if (!ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus)) {
                this.addErrorMessage(entity, bizResource.getLoanInterestConfirmStatus());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = data.getDynamicObject("productfactory"))) && !productFactory.getBoolean("iscallint")) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e3a\u4e0d\u8ba1\u606f\u3002", (String)"LoanBillAutoInterestValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            String repaymentWay = data.getString("repaymentway");
            ArrayList repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.dbdx.getValue()});
            if (repayWays.contains(repaymentWay)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u65b9\u5f0f\u4e3a\u7b49\u989d\u672c\u606f\u3001\u7b49\u989d\u672c\u91d1\u3001\u7b49\u672c\u7b49\u606f\u65f6,\u4e0d\u80fd\u8fdb\u884c\u4ed8\u606f\u64cd\u4f5c\u3002", (String)"LoanBillAutoInterestValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(submitInterestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"billstatus", (QFilter[])new QFilter[]{loanbillnoFilter = new QFilter("sourcebillid", "=", data.getPkValue()), confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())})))) {
                this.addErrorMessage(entity, bizResource.getIbSubmitOnlyoneValidator());
            }
            String entityName = data.getDynamicObjectType().getName();
            String loanType = data.getString("loantype");
            if ("cfm_loanbill_bond".equals(entityName) && !LoanTypeEnum.BOND.getValue().equals(loanType) || !"cfm_loanbill_bond".equals(entityName) && LoanTypeEnum.BOND.getValue().equals(loanType)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0:%1$s\u4e0e\u8d37\u6b3e\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"LoanBillAutoRepayValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]), entityName, LoanTypeEnum.getName((String)loanType)));
            }
            if (!this.validateOnWayBill(data)) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6279\u91cf\u4ed8\u606f\u5355\u3002", (String)"LoanBillAutoRepayValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]), data.getString("billno")));
        }
    }

    private boolean validateOnWayBill(DynamicObject loanBill) {
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.loanbillid", "=", loanBill.getPkValue()));
        qfilter.and(new QFilter("biztype", "=", (Object)"loan"));
        return TmcDataServiceHelper.exists((String)"cfm_intbill_batch_loan", (QFilter[])qfilter.toArray());
    }
}

