/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillAcctInputValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("datasource");
        sic.add("loantype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        if ("false".equals(this.getOption().getVariableValue("InnerLoanNoValidateAcctBank", "false"))) {
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                DynamicObject loanBill = dataEntity.getDataEntity();
                String dataSource = loanBill.getString("datasource");
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
                if (!LoanTypeEnum.isLinklend((String)loanBill.getString("loantype")) || !DataSourceEnum.isInvest((String)dataSource) && !DataSourceEnum.isCfm((String)dataSource)) continue;
                if (EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("accountbank"))) {
                    this.addErrorMessage(dataEntity, bizResource.getAcctBankNotNull());
                }
                if (!EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("loaneracctbank"))) continue;
                this.addErrorMessage(dataEntity, bizResource.getLoanAcctBankNotNull());
            }
        }
    }
}

