/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillAutoInterestValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("drawtype");
        selector.add("confirmstatus");
        selector.add("productfactory");
        selector.add("repaymentway");
        selector.add("datasource");
        selector.add("interest_entry");
        selector.add("loantype");
        selector.add("interest_entry.interesdate");
        selector.add("interest_entry.intstate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObjectCollection interestEntrys;
            QFilter confirmFilter;
            QFilter loanbillnoFilter;
            DynamicObjectCollection submitInterestBills;
            DynamicObject productFactory;
            DynamicObject data = entity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            String drawType = data.getString("drawtype");
            ArrayList status = Lists.newArrayList((Object[])new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue(), DrawTypeEnum.ALLPAYMENT.getValue()});
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus")) || !status.contains(drawType)) {
                this.addErrorMessage(entity, bizResource.getLoanInterestStatus());
            }
            String confirmStatus = data.getString("confirmstatus");
            if (!ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus)) {
                this.addErrorMessage(entity, bizResource.getLoanInterestConfirmStatus());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = data.getDynamicObject("productfactory"))) && !productFactory.getBoolean("iscallint")) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u878d\u8d44\u6a21\u578b\u4e3a\u4e0d\u8ba1\u606f\u3002", (String)"LoanBillAutoInterestValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            String repaymentWay = data.getString("repaymentway");
            ArrayList repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.dbdx.getValue()});
            if (repayWays.contains(repaymentWay)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u65b9\u5f0f\u4e3a\u7b49\u989d\u672c\u606f\u3001\u7b49\u989d\u672c\u91d1\u3001\u7b49\u672c\u7b49\u606f\u65f6,\u4e0d\u80fd\u8fdb\u884c\u4ed8\u606f\u64cd\u4f5c\u3002", (String)"LoanBillAutoInterestValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(submitInterestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"billstatus", (QFilter[])new QFilter[]{loanbillnoFilter = new QFilter("sourcebillid", "=", data.getPkValue()), confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue())})))) {
                this.addErrorMessage(entity, bizResource.getIbSubmitOnlyoneValidator());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(interestEntrys = data.getDynamicObjectCollection("interest_entry"))) || interestEntrys.size() == 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ed8\u606f\u8ba1\u5212\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u4ed8\u606f\u3002", (String)"LoanBillAutoInterestValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
            } else {
                List instBills = interestEntrys.stream().filter(o -> o.getDate("interesdate").compareTo(DateUtils.getCurrentDate()) <= 0 && "0".equals(o.getString("intstate"))).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(instBills)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6ca1\u6709\u6267\u884c\u65e5\u671f\u4e4b\u524d\u7684\u672a\u6267\u884c\u4ed8\u606f\u8ba1\u5212\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"LoanBillAutoInterestValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            }
            String entityName = data.getDynamicObjectType().getName();
            String loanType = data.getString("loantype");
            if ((!"cfm_loanbill_bond".equals(entityName) || LoanTypeEnum.BOND.getValue().equals(loanType)) && ("cfm_loanbill_bond".equals(entityName) || !LoanTypeEnum.BOND.getValue().equals(loanType))) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0:%1$s\u4e0e\u8d37\u6b3e\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"LoanBillAutoRepayValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]), entityName, LoanTypeEnum.getName((String)loanType)));
        }
    }
}

